/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.pdf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import uy.ub.agesic.fd.business.validation.CARootValidation;
import uy.ub.agesic.fd.business.validation.CRLValidation;
import uy.ub.agesic.fd.business.validation.UserCertificateValidation;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.dto.UbicacionFirma;
import uy.ub.agesic.fd.enums.MetodoFirmaEnum;
import uy.ub.agesic.fd.exceptions.CARootVerificationException;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.pdf.CMSTypedDataInputStream;
import uy.ub.agesic.fd.pdf.FormatSign;
import uy.ub.agesic.fd.pdf.TextoFirmaResultado;
import uy.ub.agesic.fd.store.SofisCertificate;
import uy.ub.agesic.fd.store.pkcs11.PKCS11Util;
import uy.ub.agesic.fd.utils.SofisFile;

public class EmbedSignature
implements SignatureInterface {
    private static final Logger logger = Logger.getLogger(EmbedSignature.class.getName());
    private String pinCode = "1234";
    private String typeToSign = "CEDULA";
    private SofisCertificate certificate;
    private RDN cn;
    private RDN serialNumber;
    private ConfigurationUtil cfgUtil;
    private MessagesUtil msgUtil;
    private Preferences prefs = Preferences.userRoot().node("PREFERENCES");
    private ProcesoHolder holder = ProcesoHolder.getInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] sign(InputStream docStream) throws IOException {
        byte[] returnData = null;
        PrivateKey privateKey = null;
        boolean crl = this.cfgUtil.getBooleanValue("CRL_ENABLED");
        boolean CA_ROOT_VALIDATION = this.cfgUtil.getBooleanValue("CA_ROOT_VALIDATION_ENABLE");
        boolean USER_VALIDATION = this.cfgUtil.getBooleanValue("USER_VALIDATION_ENABLE");
        try {
            if (this.certificate.getStore().getProvider(this.certificate) != null) {
                Security.addProvider(this.certificate.getStore().getProvider(this.certificate));
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            PKCS11Util util = new PKCS11Util(this.cfgUtil, this.msgUtil);
            String provider = "BC";
            if (this.typeToSign.equals(MetodoFirmaEnum.CEDULA.name()) || this.typeToSign.equals(MetodoFirmaEnum.TOKEN_ABITAB.name()) || this.typeToSign.equals(MetodoFirmaEnum.TOKEN_CORREO.name())) {
                provider = util.getActiveProvider().getName();
            }
            privateKey = this.certificate.getStore().getPrivateKey(this.certificate, this.pinCode);
            X509Certificate X509cert = this.certificate.getCertificate();
            if (X509cert.getNotAfter().before(Calendar.getInstance().getTime())) {
                throw new CARootVerificationException(this.msgUtil.getValue("MSG_CAROOT_EXPIRED"));
            }
            if (USER_VALIDATION) {
                UserCertificateValidation.validateCertificate(X509cert, "USER_DATA");
            }
            if (crl) {
                CRLValidation.validateCertificate(X509cert);
            }
            if (CA_ROOT_VALIDATION) {
                HashSet<X509Certificate> additionalCerts = null;
                try {
                    String password = this.cfgUtil.getValue("KEYSTORE_TRUSTORE_PASS");
                    additionalCerts = new HashSet<X509Certificate>();
                    KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    InputStream is = this.cfgUtil.getInputStream("KEYSTORE_TRUSTORE_NAME");
                    if (is != null) {
                        keystore.load(is, password.toCharArray());
                        PKIXParameters params = new PKIXParameters(keystore);
                        for (TrustAnchor ta : params.getTrustAnchors()) {
                            X509Certificate trustCert = ta.getTrustedCert();
                            additionalCerts.add(trustCert);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    throw new CARootVerificationException(this.msgUtil.getValue("MSG_CARootValidation_ERROR_GENERAL"));
                }
                if (additionalCerts == null) throw new CARootVerificationException(this.msgUtil.getValue("MSG_CARootValidation_ERROR_GENERAL"));
                PKIXCertPathBuilderResult res = CARootValidation.validateCertificate(X509cert, additionalCerts);
                if (res == null) {
                    // empty if block
                }
            }
            Certificate[] certChain = new Certificate[]{X509cert};
            ArrayList<X509CertificateHolder> signingChainHolder = new ArrayList<X509CertificateHolder>();
            for (int i = 0; i < certChain.length; ++i) {
                signingChainHolder.add(new X509CertificateHolder(certChain[i].getEncoded()));
            }
            JcaCertStore certStore = new JcaCertStore(signingChainHolder);
            CMSTypedDataInputStream input = new CMSTypedDataInputStream(docStream);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            ContentSigner sha256Signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider(provider).build(privateKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha256Signer, (X509Certificate)certChain[0]));
            gen.addCertificates((Store)certStore);
            CMSSignedData signedData = gen.generate((CMSTypedData)input, false);
            return signedData.getEncoded();
        }
        catch (CARootVerificationException e) {
            throw new IOException("Error en validaci\u00f3n del certificado: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IOException("Error durante la firma: " + e.getMessage(), e);
        }
    }

    public SofisFile signPDF(SofisCertificate certificate, String certificatePassword, SofisFile pdfToSign, String typeToSign, UbicacionFirma ubicacionFirma, HashMap<String, String> options) throws Exception {
        this.pinCode = certificatePassword;
        this.certificate = certificate;
        this.typeToSign = typeToSign;
        this.cfgUtil = new ConfigurationUtil(options);
        this.msgUtil = new MessagesUtil(options);
        String pdfAppLocation = this.msgUtil.getValue("PDFSIGNATURE_APPEARANCE_LOCATION");
        String pdfAppReason = this.msgUtil.getValue("PDFSIGNATURE_APPEARANCE_REASON");
        X500Name x500name = new JcaX509CertificateHolder(certificate.getCertificate()).getSubject();
        this.cn = x500name.getRDNs(BCStyle.CN)[0];
        this.serialNumber = !typeToSign.equals(MetodoFirmaEnum.P12.name()) ? x500name.getRDNs(BCStyle.SERIALNUMBER)[0] : null;
        PDRectangle rect = new PDRectangle(Float.valueOf(ubicacionFirma.getPosX()).floatValue(), Float.valueOf(ubicacionFirma.getPosY()).floatValue(), Float.valueOf(ubicacionFirma.getWidth()).floatValue(), Float.valueOf(ubicacionFirma.getHeight()).floatValue());
        try (PDDocument pdDocument = PDDocument.load((byte[])pdfToSign.getBytes());){
            PDSignature signature = null;
            PDAcroForm acroForm = pdDocument.getDocumentCatalog().getAcroForm();
            String fieldName = "firmagubuy";
            if (acroForm != null && fieldName != null && (signature = this.findExistingSignature(acroForm, fieldName)) != null) {
                rect = ((PDAnnotationWidget)acroForm.getField(fieldName).getWidgets().get(0)).getRectangle();
            }
            if (signature == null) {
                signature = new PDSignature();
            }
            if (rect == null) {
                rect = this.createSignatureRectangle(pdDocument, new Rectangle2D.Float(ubicacionFirma.getPosX(), ubicacionFirma.getPosY(), ubicacionFirma.getWidth(), ubicacionFirma.getHeight()));
            }
            if (acroForm != null && acroForm.getNeedAppearances()) {
                if (acroForm.getFields().isEmpty()) {
                    acroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
                } else {
                    System.out.println("/NeedAppearances is set, signature may be ignored by Adobe Reader");
                }
            }
            signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
            signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
            signature.setSignDate(Calendar.getInstance());
            signature.setLocation(pdfAppLocation);
            signature.setReason(pdfAppReason);
            SignatureOptions signatureOptions = new SignatureOptions();
            signatureOptions.setVisualSignature(this.createVisualSignatureTemplate(pdDocument, ubicacionFirma != null ? ubicacionFirma.getPagina() : 0, rect));
            signatureOptions.setPage(ubicacionFirma != null ? ubicacionFirma.getPagina() : 0);
            pdDocument.addSignature(signature, (SignatureInterface)this, signatureOptions);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            System.out.println("signedData size: " + (baos != null) + " *** " + baos.size());
            pdDocument.saveIncremental((OutputStream)baos);
            pdDocument.close();
            IOUtils.closeQuietly((Closeable)signatureOptions);
            SofisFile sofisFile = new SofisFile(pdfToSign.getNombre(), pdfToSign.getIdentificadorFile(), baos.toByteArray(), pdfToSign.getTipo());
            return sofisFile;
        }
    }

    private PDRectangle createSignatureRectangle(PDDocument doc, Rectangle2D humanRect) {
        float x = (float)humanRect.getX();
        float y = (float)humanRect.getY();
        float width = (float)humanRect.getWidth();
        float height = (float)humanRect.getHeight();
        PDPage page = doc.getPage(0);
        PDRectangle pageRect = page.getCropBox();
        PDRectangle rect = new PDRectangle();
        switch (page.getRotation()) {
            case 90: {
                rect.setLowerLeftY(x);
                rect.setUpperRightY(x + width);
                rect.setLowerLeftX(y);
                rect.setUpperRightX(y + height);
                break;
            }
            case 180: {
                rect.setUpperRightX(pageRect.getWidth() - x);
                rect.setLowerLeftX(pageRect.getWidth() - x - width);
                rect.setLowerLeftY(y);
                rect.setUpperRightY(y + height);
                break;
            }
            case 270: {
                rect.setLowerLeftY(pageRect.getHeight() - x - width);
                rect.setUpperRightY(pageRect.getHeight() - x);
                rect.setLowerLeftX(pageRect.getWidth() - y - height);
                rect.setUpperRightX(pageRect.getWidth() - y);
                break;
            }
            default: {
                rect.setLowerLeftX(x);
                rect.setUpperRightX(x + width);
                rect.setLowerLeftY(pageRect.getHeight() - y - height);
                rect.setUpperRightY(pageRect.getHeight() - y);
            }
        }
        return rect;
    }

    private InputStream createVisualSignatureTemplate(PDDocument srcDoc, int pageNum, PDRectangle rect) throws Exception {
        try (PDDocument doc = new PDDocument();){
            FormatSign formatSign = new FormatSign();
            String t1 = this.msgUtil.getValue("PDFSIGNATURE_APPEARANCE_INFO");
            String t2 = this.msgUtil.getValue("PDFSIGNATURE_APPEARANCE_SIGN_BY");
            String t3 = this.msgUtil.getValue("PDFSIGNATURE_APPEARANCE_DOCUMENT");
            String t4 = this.msgUtil.getValue("PDFSIGNATURE_APPEARANCE_DATE");
            PDPage page = new PDPage(srcDoc.getPage(pageNum).getMediaBox());
            doc.addPage(page);
            PDAcroForm acroForm = new PDAcroForm(doc);
            doc.getDocumentCatalog().setAcroForm(acroForm);
            PDSignatureField signatureField = new PDSignatureField(acroForm);
            PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
            List acroFormFields = acroForm.getFields();
            acroForm.setSignaturesExist(true);
            acroForm.setAppendOnly(true);
            acroForm.getCOSObject().setDirect(true);
            acroFormFields.add(signatureField);
            widget.setRectangle(rect);
            PDStream stream = new PDStream(doc);
            PDFormXObject form = new PDFormXObject(stream);
            PDResources res = new PDResources();
            form.setResources(res);
            form.setFormType(1);
            PDRectangle bbox = new PDRectangle(rect.getWidth(), rect.getHeight());
            float height = bbox.getHeight();
            Matrix initialScale = null;
            switch (srcDoc.getPage(pageNum).getRotation()) {
                case 90: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                    initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                    height = bbox.getWidth();
                    break;
                }
                case 180: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                    break;
                }
                case 270: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                    initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                    height = bbox.getWidth();
                    break;
                }
            }
            form.setBBox(bbox);
            PDType1Font font = PDType1Font.HELVETICA;
            PDAppearanceDictionary appearance = new PDAppearanceDictionary();
            appearance.getCOSObject().setDirect(true);
            PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
            appearance.setNormalAppearance(appearanceStream);
            widget.setAppearance(appearance);
            PDPageContentStream cs = new PDPageContentStream(doc, appearanceStream);
            Object object = null;
            try {
                if (initialScale != null) {
                    cs.transform(initialScale);
                }
                PDExtendedGraphicsState normalState = new PDExtendedGraphicsState();
                normalState.setNonStrokingAlphaConstant(Float.valueOf(1.0f));
                normalState.setStrokingAlphaConstant(Float.valueOf(1.0f));
                cs.setGraphicsStateParameters(normalState);
                byte[] bytes = null;
                this.holder.setRequiereCargarImg(false);
                if (!this.prefs.get("IMAGE_SIGN_URI", "").equals("")) {
                    File file = new File(this.prefs.get("IMAGE_SIGN_URI", ""));
                    if (file.exists() && !file.isDirectory()) {
                        bytes = IOUtils.toByteArray((InputStream)new FileInputStream(file));
                        if (bytes != null) {
                            PDImageXObject img = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])bytes, null);
                            Float imageMaxWidth = Float.valueOf(rect.getWidth() / 2.0f);
                            Float imageMaxHeight = Float.valueOf(rect.getHeight());
                            float scale = Math.min(imageMaxWidth.floatValue() / (float)img.getWidth(), imageMaxHeight.floatValue() / (float)img.getHeight());
                            Float imageWidthWithScale = Float.valueOf((float)img.getWidth() * scale);
                            Float imageHeightWithScale = Float.valueOf((float)img.getHeight() * scale);
                            Float alignCenterXMove = Float.valueOf((imageMaxWidth.floatValue() - imageWidthWithScale.floatValue()) / 2.0f / scale);
                            Float alignCenterYMove = Float.valueOf((imageMaxHeight.floatValue() - imageHeightWithScale.floatValue()) / 2.0f / scale);
                            cs.saveGraphicsState();
                            cs.transform(Matrix.getScaleInstance((float)scale, (float)scale));
                            cs.drawImage(img, alignCenterXMove.floatValue(), alignCenterYMove.floatValue());
                            cs.restoreGraphicsState();
                        }
                    } else {
                        logger.log(Level.INFO, "No se encontr\u00f3 imagen de firma en: {0}", this.prefs.get(this.prefs.get("IMAGE_SIGN_URI", ""), ""));
                        this.holder.setRequiereCargarImg(true);
                        TextoFirmaResultado resultado = formatSign.calcularTextoFirma(t1, t2, t3, t4, this.certificate.getCertificate(), rect);
                        float padding = 4.0f;
                        float fontSize = resultado.fontSize;
                        float leading = fontSize * 1.2f;
                        float startX = padding;
                        float startY = rect.getHeight() - padding - fontSize;
                        cs.beginText();
                        cs.setFont((PDFont)PDType1Font.HELVETICA, fontSize);
                        cs.setNonStrokingColor(Color.BLACK);
                        cs.setLeading(leading);
                        cs.newLineAtOffset(startX, startY);
                        for (String linea : resultado.lineas) {
                            cs.showText(linea);
                            cs.newLine();
                        }
                        cs.endText();
                    }
                } else {
                    TextoFirmaResultado resultado = formatSign.calcularTextoFirma(t1, t2, t3, t4, this.certificate.getCertificate(), rect);
                    float padding = 4.0f;
                    float fontSize = resultado.fontSize;
                    float leading = fontSize * 1.2f;
                    float startX = padding;
                    float startY = rect.getHeight() - padding - fontSize;
                    cs.beginText();
                    cs.setFont((PDFont)PDType1Font.HELVETICA, fontSize);
                    cs.setNonStrokingColor(Color.BLACK);
                    cs.setLeading(leading);
                    cs.newLineAtOffset(startX, startY);
                    for (String linea : resultado.lineas) {
                        cs.showText(linea);
                        cs.newLine();
                    }
                    cs.endText();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (cs != null) {
                    if (object != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        cs.close();
                    }
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            doc.save((OutputStream)baos);
            object = new ByteArrayInputStream(baos.toByteArray());
            return object;
        }
    }

    private PDSignature findExistingSignature(PDAcroForm acroForm, String sigFieldName) {
        PDSignatureField signatureField;
        PDSignature signature = null;
        if (acroForm != null && (signatureField = (PDSignatureField)acroForm.getField(sigFieldName)) != null) {
            signature = signatureField.getSignature();
            if (signature == null) {
                signature = new PDSignature();
                signatureField.getCOSObject().setItem(COSName.V, (COSObjectable)signature);
            } else {
                throw new IllegalStateException("The signature field " + sigFieldName + " is already signed.");
            }
        }
        return signature;
    }
}

