/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.pdf;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.pdf.TextoFirmaResultado;

public class FormatSign {
    private Preferences prefs = Preferences.userRoot().node("PREFERENCES");
    private static final Logger LOGGER = Logger.getLogger(AppViewer.class.getName());

    public TextoFirmaResultado calcularTextoFirma(String t1, String t2, String t3, String t4, Certificate cert, PDRectangle rect) {
        X509Certificate x509 = (X509Certificate)cert;
        String textoFirma = this.formatInfoCert(t1, t2, t3, t4, x509);
        PDType1Font font = PDType1Font.HELVETICA;
        float maxFontSize = 14.0f;
        float minFontSize = 1.5f;
        float leadingFactor = 1.2f;
        float padding = 4.0f;
        float availableWidth = rect.getWidth() - 2.0f * padding;
        float availableHeight = rect.getHeight() - 2.0f * padding;
        List<String> bestLineas = new ArrayList<String>();
        float bestFontSize = minFontSize;
        for (float fontSize = maxFontSize; fontSize >= minFontSize; fontSize -= minFontSize) {
            List<String> lineas = this.wrapText((PDFont)font, textoFirma, fontSize, availableWidth);
            float totalHeight = (float)lineas.size() * fontSize * leadingFactor;
            if (!(totalHeight <= availableHeight)) continue;
            bestLineas = lineas;
            bestFontSize = fontSize;
            break;
        }
        return new TextoFirmaResultado(bestFontSize, bestLineas);
    }

    private List<String> wrapText(PDFont font, String texto, float fontSize, float maxWidth) {
        String[] parrafos;
        ArrayList<String> lineas = new ArrayList<String>();
        for (String parrafo : parrafos = texto.split("\n")) {
            String[] palabras = parrafo.split("\\s+");
            StringBuilder lineaActual = new StringBuilder();
            for (String palabra : palabras) {
                String candidata = lineaActual.length() == 0 ? palabra : lineaActual + " " + palabra;
                float ancho = this.getStringWidth(font, candidata, fontSize);
                if (ancho > maxWidth) {
                    if (lineaActual.length() > 0) {
                        lineas.add(lineaActual.toString());
                        lineaActual = new StringBuilder();
                    }
                    if (this.getStringWidth(font, palabra, fontSize) > maxWidth) {
                        lineas.addAll(this.splitWord(palabra, font, fontSize, maxWidth));
                        continue;
                    }
                    lineaActual = new StringBuilder(palabra);
                    continue;
                }
                lineaActual = new StringBuilder(candidata);
            }
            if (lineaActual.length() > 0) {
                lineas.add(lineaActual.toString());
            }
            if (palabras.length != 0) continue;
            lineas.add("");
        }
        return lineas;
    }

    private float getStringWidth(PDFont font, String text, float fontSize) {
        try {
            return font.getStringWidth(text) / 1000.0f * fontSize;
        }
        catch (IOException e) {
            return Float.MAX_VALUE;
        }
    }

    private List<String> splitWord(String palabra, PDFont font, float fontSize, float maxWidth) {
        ArrayList<String> partes = new ArrayList<String>();
        StringBuilder actual = new StringBuilder();
        for (char c : palabra.toCharArray()) {
            actual.append(c);
            if (!(this.getStringWidth(font, actual.toString(), fontSize) > maxWidth)) continue;
            actual.setLength(actual.length() - 1);
            if (actual.length() > 0) {
                partes.add(actual.toString());
            }
            actual = new StringBuilder().append(c);
        }
        if (actual.length() > 0) {
            partes.add(actual.toString());
        }
        return partes;
    }

    public String formatInfoCert(String t1, String t2, String t3, String t4, X509Certificate cert) {
        StringBuilder sb = new StringBuilder();
        String nombreFirmante = FormatSign.extraerCampoDN(cert.getSubjectX500Principal().getName(), "CN");
        String autoridadCertificadora = FormatSign.extraerCampoDN(cert.getIssuerX500Principal().getName(), "CN");
        LocalDateTime fecha = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        String fechaHoraFormateada = fecha.format(formatter);
        String serial = cert.getSerialNumber().toString(16).toUpperCase();
        Boolean customSignature = StringUtils.isNotBlank((CharSequence)this.prefs.get("CUSTOMIZE_SIGNATURE", "")) && this.prefs.get("CUSTOMIZE_SIGNATURE", "").equalsIgnoreCase("true");
        LOGGER.log(Level.INFO, "Estampa de firma personalizada {0}", customSignature);
        if (!customSignature.booleanValue()) {
            sb.append(t1).append("\n");
            sb.append(t2).append(StringUtils.isNotBlank((CharSequence)nombreFirmante) ? nombreFirmante : "").append("\n");
            sb.append(t3).append(StringUtils.isNotBlank((CharSequence)serial) ? serial : "").append("\n");
            sb.append(t4).append(fechaHoraFormateada).append("\n").append("\n");
            sb.append(autoridadCertificadora).append("\n");
        } else {
            Boolean addText1 = StringUtils.isNotBlank((CharSequence)this.prefs.get("SIGN_INC_FIRMA_AVAZADA", "")) && this.prefs.get("SIGN_INC_FIRMA_AVAZADA", "").equalsIgnoreCase("true");
            Boolean addText2 = StringUtils.isNotBlank((CharSequence)this.prefs.get("SIGN_INC_FIRMADO_POR", "")) && this.prefs.get("SIGN_INC_FIRMADO_POR", "").equalsIgnoreCase("true");
            Boolean addText3 = StringUtils.isNotBlank((CharSequence)this.prefs.get("SIGN_INC_DOCUMENTO", "")) && this.prefs.get("SIGN_INC_DOCUMENTO", "").equalsIgnoreCase("true");
            Boolean addText4 = StringUtils.isNotBlank((CharSequence)this.prefs.get("SIGN_INC_FECHA", "")) && this.prefs.get("SIGN_INC_FECHA", "").equalsIgnoreCase("true");
            Boolean addText5 = StringUtils.isNotBlank((CharSequence)this.prefs.get("SIGN_INC_AUTORIDAD", "")) && this.prefs.get("SIGN_INC_AUTORIDAD", "").equalsIgnoreCase("true");
            if (addText1.booleanValue()) {
                sb.append(t1).append("\n");
            }
            if (addText2.booleanValue()) {
                sb.append(t2).append(StringUtils.isNotBlank((CharSequence)nombreFirmante) ? nombreFirmante : "").append("\n");
            }
            if (addText3.booleanValue()) {
                sb.append(t3).append(StringUtils.isNotBlank((CharSequence)serial) ? serial : "").append("\n");
            }
            if (addText4.booleanValue()) {
                sb.append(t4).append(fechaHoraFormateada).append("\n").append("\n");
            }
            if (addText5.booleanValue()) {
                sb.append(autoridadCertificadora).append("\n");
            }
        }
        return sb.toString();
    }

    private static String extraerCampoDN(String dn, String campo) {
        try {
            LdapName ldapName = new LdapName(dn);
            for (Rdn rdn : ldapName.getRdns()) {
                if (!campo.equalsIgnoreCase(rdn.getType())) continue;
                return rdn.getValue().toString();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    private Map<String, String> parseDN(String dn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

