/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.pdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PDFBoxSofisUtil {
    private static final Logger LOGGER = Logger.getLogger(PDFBoxSofisUtil.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PDDocument transformarDocumento(byte[] bt) {
        try (PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(bt));){
            PDDocument pDDocument = document;
            return pDDocument;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error en al convertir documento", e);
            return null;
        }
    }

    public static int numeroPaginasDeDocumento(byte[] bt) {
        PDDocument document = PDFBoxSofisUtil.transformarDocumento(bt);
        if (document != null) {
            return document.getNumberOfPages();
        }
        return 0;
    }
}

