/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.exceptions.DriverException;
import uy.ub.agesic.fd.exceptions.StoreInvalidPasswordException;
import uy.ub.agesic.fd.store.CertStoreI;
import uy.ub.agesic.fd.store.CertStorePasswordI;
import uy.ub.agesic.fd.store.SofisCertificate;
import uy.ub.agesic.fd.store.browser.IECertStoreImpl;
import uy.ub.agesic.fd.store.browser.MozillaCertStoreImpl;
import uy.ub.agesic.fd.store.pkcs11.PKCS11CertStoreImpl;

public class StoreManagment {
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    private boolean PKCS11_TOKEN_DETECTED = false;
    List<CertStoreI> certStoreList = new ArrayList<CertStoreI>();

    public void addCertStore(CertStoreI store) {
        this.certStoreList.add(store);
    }

    public List<SofisCertificate> getSignCertificateFromBrowser() throws StoreInvalidPasswordException {
        ArrayList<SofisCertificate> toReturn = new ArrayList<SofisCertificate>();
        HashMap<String, String> alias = new HashMap<String, String>();
        for (CertStoreI csI : this.certStoreList) {
            try {
                if (!(csI instanceof MozillaCertStoreImpl) && !(csI instanceof IECertStoreImpl)) continue;
                List<SofisCertificate> x509certs = csI.getSignCertificateFromStore();
                for (SofisCertificate cert : x509certs) {
                    if (alias.containsKey(cert.getAlias())) continue;
                    alias.put(cert.getAlias(), cert.getAlias());
                    toReturn.add(cert);
                }
            }
            catch (StoreInvalidPasswordException w) {
                logger.log(Level.SEVERE, "StoreInvalidPasswordException ", w);
                throw w;
            }
            catch (Exception w) {
                logger.log(Level.SEVERE, "Exception ", w);
            }
        }
        return toReturn;
    }

    public List<SofisCertificate> getSignCertificateFromPKCS11(String password, String path, PKCS11CertStoreImpl.PKCS11CertStoreType type, String activeProvider) throws StoreInvalidPasswordException, DriverException {
        ArrayList<SofisCertificate> toReturn = new ArrayList<SofisCertificate>();
        HashMap<String, String> alias = new HashMap<String, String>();
        for (CertStoreI csI : this.certStoreList) {
            try {
                if (!(csI instanceof PKCS11CertStoreImpl) || !((PKCS11CertStoreImpl)csI).getType().equals((Object)type)) continue;
                if (csI instanceof CertStorePasswordI) {
                    CertStorePasswordI csPasssI = (CertStorePasswordI)csI;
                    csPasssI.setPassword(password);
                }
                ((PKCS11CertStoreImpl)csI).setPath(path);
                this.PKCS11_TOKEN_DETECTED = true;
                List<SofisCertificate> x509certs = csI.getSignCertificateFromStore(activeProvider);
                for (SofisCertificate cert : x509certs) {
                    if (alias.containsKey(cert.getAlias())) continue;
                    alias.put(cert.getAlias(), cert.getAlias());
                    toReturn.add(cert);
                }
            }
            catch (DriverException w) {
                throw w;
            }
            catch (StoreInvalidPasswordException w) {
                if (csI instanceof PKCS11CertStoreImpl) {
                    this.PKCS11_TOKEN_DETECTED = false;
                }
                throw w;
            }
            catch (Exception w) {
                logger.log(Level.SEVERE, "Exception ", w);
            }
        }
        return toReturn;
    }

    public List<SofisCertificate> getSignCertificateFromStores(String password) throws StoreInvalidPasswordException, DriverException {
        ArrayList<SofisCertificate> toReturn = new ArrayList<SofisCertificate>();
        HashMap<String, String> alias = new HashMap<String, String>();
        for (CertStoreI csI : this.certStoreList) {
            try {
                if (csI instanceof CertStorePasswordI) {
                    CertStorePasswordI csPasssI = (CertStorePasswordI)csI;
                    csPasssI.setPassword(password);
                }
                List<SofisCertificate> x509certs = csI.getSignCertificateFromStore();
                for (SofisCertificate cert : x509certs) {
                    if (alias.containsKey(cert.getAlias())) continue;
                    alias.put(cert.getAlias(), cert.getAlias());
                    toReturn.add(cert);
                }
                if (!(csI instanceof PKCS11CertStoreImpl)) continue;
                this.PKCS11_TOKEN_DETECTED = true;
            }
            catch (DriverException w) {
                throw w;
            }
            catch (StoreInvalidPasswordException w) {
                logger.log(Level.SEVERE, "DriverException ", w);
                throw w;
            }
            catch (Exception w) {
                if (csI instanceof PKCS11CertStoreImpl) {
                    this.PKCS11_TOKEN_DETECTED = false;
                }
                logger.log(Level.SEVERE, "Exception ", w);
            }
        }
        return toReturn;
    }

    public boolean isPKCS11_TOKEN_DETECTED() {
        return this.PKCS11_TOKEN_DETECTED;
    }

    public void setPKCS11_TOKEN_DETECTED(boolean PKCS11_TOKEN_DETECTED) {
        this.PKCS11_TOKEN_DETECTED = PKCS11_TOKEN_DETECTED;
    }

    public static enum store_types {
        PKCS11,
        PKCS12,
        MOZILLA,
        IE;

    }
}

