/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.store.pkcs11;

import eu.bitwalker.useragentutils.UserAgent;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.exceptions.DriverException;
import uy.ub.agesic.fd.exceptions.StoreException;
import uy.ub.agesic.fd.exceptions.StoreInvalidPasswordException;
import uy.ub.agesic.fd.store.CertStoreI;
import uy.ub.agesic.fd.store.CertStorePasswordI;
import uy.ub.agesic.fd.store.SofisCertificate;
import uy.ub.agesic.fd.store.pkcs11.PKCS11Util;

public class PKCS11CertStoreImpl
implements CertStorePasswordI {
    private final PKCS11CertStoreType type;
    private String path;
    private String password;
    private KeyStore keyStore;
    private final UserAgent userAgent;
    private final MessagesUtil msgUtil;
    private final ConfigurationUtil cfgUtil;

    public PKCS11CertStoreImpl(PKCS11CertStoreType type, UserAgent userAgent, HashMap<String, String> opciones) {
        this.type = type;
        this.userAgent = userAgent;
        this.msgUtil = new MessagesUtil(opciones);
        this.cfgUtil = new ConfigurationUtil(opciones);
    }

    @Override
    public List<SofisCertificate> getSignCertificateFromStore() throws StoreException, DriverException, StoreInvalidPasswordException {
        return null;
    }

    @Override
    public List<SofisCertificate> getSignCertificateFromStore(String activeProvider) throws StoreException, DriverException, StoreInvalidPasswordException {
        ArrayList<SofisCertificate> toReturn = new ArrayList<SofisCertificate>();
        try {
            this.keyStore = null;
            PKCS11Util util = new PKCS11Util(this.cfgUtil, this.msgUtil);
            if (this.type.equals((Object)PKCS11CertStoreType.ETOKEN)) {
                this.keyStore = util.loadTokenKeyStore(this.password, this.userAgent, activeProvider);
            } else if (this.type.equals((Object)PKCS11CertStoreType.FILE)) {
                this.keyStore = util.loadJKSKeyStore(this.password, this.path);
            }
            if (this.keyStore != null) {
                Enumeration<String> as = this.keyStore.aliases();
                while (as.hasMoreElements()) {
                    String alias = as.nextElement();
                    try {
                        X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
                        String[] aux = cert.getSubjectDN().getName().split(",");
                        String cn = aux[0].trim().split("=")[1];
                        SofisCertificate sofisCert = new SofisCertificate(alias, cn, cert, (CertStoreI)this);
                        toReturn.add(sofisCert);
                    }
                    catch (Exception ex) {
                        SofisCertificate cert = new SofisCertificate(alias, "", null, (CertStoreI)this);
                        cert.setOk(false);
                        toReturn.add(cert);
                    }
                }
                return toReturn;
            }
            return toReturn;
        }
        catch (StoreException e) {
            throw e;
        }
        catch (StoreInvalidPasswordException e) {
            throw e;
        }
        catch (DriverException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getMessage() == "keystore password was incorrect") {
                StoreInvalidPasswordException ex = new StoreInvalidPasswordException(e.getMessage());
                throw ex;
            }
            throw new StoreException(e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(SofisCertificate certificate, String certificatePass) throws StoreException, StoreInvalidPasswordException {
        try {
            PrivateKey key = (PrivateKey)this.keyStore.getKey(certificate.getAlias(), certificatePass.toCharArray());
            return key;
        }
        catch (Exception ioEx) {
            if (ioEx.getCause() instanceof UnrecoverableKeyException || ioEx.getCause() instanceof FailedLoginException) {
                throw new StoreInvalidPasswordException(this.msgUtil.getValue("MSG_CONTRASENIA_INVALIDA"));
            }
            throw new StoreException(ioEx);
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Provider getProvider(SofisCertificate certificate) {
        return null;
    }

    public PKCS11CertStoreType getType() {
        return this.type;
    }

    public static enum PKCS11CertStoreType {
        ETOKEN,
        FILE;

    }
}

