/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.store.pkcs11;

import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.exceptions.DriverException;
import uy.ub.agesic.fd.exceptions.StoreInvalidPasswordException;
import uy.ub.agesic.fd.store.pkcs11.PKCS11ConfigFile;

public class PKCS11Util {
    MessagesUtil msgUtil;
    ConfigurationUtil cfgUtil;
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    private final String property = "java.io.tmpdir";
    private final String pathSeparator = File.separator;
    private final String eToken = "eToken";

    public PKCS11Util(ConfigurationUtil cfgUtil, MessagesUtil msgUtil) {
        this.msgUtil = msgUtil;
        this.cfgUtil = cfgUtil;
    }

    public void verificarMetodosDisponibles(String path, String modelo, UserAgent userAgent) throws IOException {
        String name;
        File f;
        String configFilePath;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(this.pathSeparator)) {
            tempDir = tempDir + this.pathSeparator;
        }
        if (modelo.contains("Aladdin")) {
            configFilePath = tempDir + "aladdin.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "aladdin.cfg.bk"));
            }
            f.createNewFile();
            name = "aladdin";
            this.writeFile(f, name, path, userAgent.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS_7), "2", userAgent);
        }
        if (modelo.contains("SafeNet")) {
            configFilePath = tempDir + "safenet.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "safenet.cfg.bk"));
            }
            f.createNewFile();
            name = "safenet";
            this.writeFile(f, name, path, true, "6", userAgent);
        }
        if (modelo.contains("ePass2003")) {
            configFilePath = tempDir + "epass2003.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "epass2003.cfg.bk"));
            }
            f.createNewFile();
            name = "epass2003";
            this.writeFile(f, name, path, false, "", userAgent);
        }
        if (modelo.contains("ePass3003Auto")) {
            configFilePath = tempDir + "epass3003auto.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "epass3003auto.cfg.bk"));
            }
            f.createNewFile();
            name = "epass3003auto";
            this.writeFile(f, name, path, false, "", userAgent);
        }
        if (modelo.contains("Gemalto") || modelo.contains("Cedula")) {
            configFilePath = tempDir + "gemalto.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "gemalto.cfg.bk"));
            }
            f.createNewFile();
            name = "gemalto";
            this.writeFile(f, name, path, false, "", userAgent);
        }
        if (modelo.contains("ACSCryptoMate") || modelo.contains("Abitab")) {
            configFilePath = tempDir + "aCSCryptoMate.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "aCSCryptoMate.cfg.bk"));
            }
            f.createNewFile();
            name = "aCSCryptoMate";
            this.writeFile(f, name, path, false, "", userAgent);
        }
        if (modelo.equals("Otro")) {
            File f2;
            int i = 1;
            do {
                configFilePath = tempDir + "eToken" + i + ".cfg";
                f2 = new File(configFilePath);
                name = "eToken" + i;
                ++i;
            } while (f2.exists());
            f2.createNewFile();
            this.writeFile(f2, name, path, false, "", userAgent);
        }
    }

    public void createConfigFile(String path, String modelo, UserAgent userAgent) throws IOException {
        String name;
        File f;
        String configFilePath;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(this.pathSeparator)) {
            tempDir = tempDir + this.pathSeparator;
        }
        if (modelo.contains("Aladdin")) {
            configFilePath = tempDir + "aladdin.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "aladdin.cfg.bk"));
            }
            f.createNewFile();
            name = "aladdin";
            this.writeFile(f, name, path, userAgent.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS_7), "2", userAgent);
        }
        if (modelo.contains("SafeNet")) {
            configFilePath = tempDir + "safenet.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "safenet.cfg.bk"));
            }
            f.createNewFile();
            name = "safenet";
            this.writeFile(f, name, path, true, "6", userAgent);
        }
        if (modelo.contains("ePass2003")) {
            configFilePath = tempDir + "epass2003.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "epass2003.cfg.bk"));
            }
            f.createNewFile();
            name = "epass2003";
            this.writeFile(f, name, path, false, "", userAgent);
        }
        if (modelo.contains("ePass3003Auto")) {
            configFilePath = tempDir + "epass3003auto.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "epass3003auto.cfg.bk"));
            }
            f.createNewFile();
            name = "epass3003auto";
            this.writeFile(f, name, path, false, "", userAgent);
        }
        if (modelo.contains("Gemalto") || modelo.contains("Cedula")) {
            configFilePath = tempDir + "gemalto.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "gemalto.cfg.bk"));
            }
            f.createNewFile();
            name = "gemalto";
            this.writeFile(f, name, path, false, "", userAgent);
        }
        if (modelo.contains("ACSCryptoMate") || modelo.contains("Abitab")) {
            configFilePath = tempDir + "aCSCryptoMate.cfg";
            f = new File(configFilePath);
            if (f.exists()) {
                f.renameTo(new File(tempDir + "aCSCryptoMate.cfg.bk"));
            }
            f.createNewFile();
            name = "aCSCryptoMate";
            this.writeFile(f, name, path, false, "", userAgent);
        }
        if (modelo.equals("Otro")) {
            File f2;
            int i = 1;
            do {
                configFilePath = tempDir + "eToken" + i + ".cfg";
                f2 = new File(configFilePath);
                name = "eToken" + i;
                ++i;
            } while (f2.exists());
            f2.createNewFile();
            this.writeFile(f2, name, path, false, "", userAgent);
        }
    }

    protected static Long slotInfo(String dllPksc11) throws Exception {
        int n = 0;
        PKCS11 p11 = PKCS11.getInstance(dllPksc11, "C_GetFunctionList", null, false);
        long[] slots = p11.C_GetSlotList(true);
        long[] lArray = slots;
        int n2 = lArray.length;
        if (n < n2) {
            long sl = lArray[n];
            CK_SLOT_INFO info = p11.C_GetSlotInfo(sl);
            return sl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File f, String name, String lib, boolean slot, String slotId, UserAgent userAgent) throws IOException {
        boolean isWindows = false;
        if (userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.UNKNOWN)) {
            String os = System.getProperty("os.name");
            isWindows = os != null && os.toLowerCase().indexOf("win") >= 0;
        }
        if (isWindows || userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.WINDOWS)) {
            lib = lib.replace("\\", "\\\\");
            lib = "\"" + lib + "\"";
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f));
            out.write("name = " + name);
            out.newLine();
            out.write("library = " + lib);
            out.newLine();
            Long slotIdl = null;
            try {
                slotIdl = PKCS11Util.slotInfo(lib);
            }
            catch (Exception w) {
                logger.log(Level.SEVERE, "Exception ", w);
            }
            if (slotIdl != null) {
                out.write("slot= " + slotIdl);
                out.newLine();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException ", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "IOException ", e);
                }
            }
        }
    }

    public String loadETokenLib(String model, UserAgent userAgent) {
        String os;
        boolean isWindows = false;
        boolean isLinux = false;
        if (userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.UNKNOWN) && !StringUtils.isBlank((CharSequence)(os = System.getProperty("os.name")))) {
            isWindows = os.toLowerCase().indexOf("win") >= 0;
            isLinux = os.toLowerCase().indexOf("nix") >= 0 || os.toLowerCase().indexOf("nux") >= 0 || os.toLowerCase().indexOf("aix") > 0;
        }
        if (isWindows || userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.WINDOWS)) {
            if (model.contains("Aladdin")) {
                return this.cfgUtil.getValue("LIB_ALADDIN_WIN");
            }
            if (model.contains("SafeNet")) {
                return this.cfgUtil.getValue("LIB_SAFENET_WIN");
            }
            if (model.contains("ePass2003")) {
                return this.cfgUtil.getValue("LIB_EPASS2003_WIN");
            }
            if (model.contains("ePass3003Auto")) {
                return this.cfgUtil.getValue("LIB_EPASS3003_WIN");
            }
            if (model.contains("Gemalto")) {
                return this.cfgUtil.getValue("LIB_GEMALTO_WIN");
            }
            if (model.contains("ACSCryptoMate")) {
                return this.cfgUtil.getValue("LIB_ACSCryptoMate_WIN");
            }
        }
        if (isLinux || userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.LINUX)) {
            if (model.contains("Aladdin")) {
                return this.cfgUtil.getValue("LIB_ALADDIN_LIN");
            }
            if (model.contains("SafeNet")) {
                return this.cfgUtil.getValue("LIB_SAFENET_LIN");
            }
            if (model.contains("ePass2003")) {
                return this.cfgUtil.getValue("LIB_EPASS2003_LIN");
            }
            if (model.contains("ePass3003Auto")) {
                return this.cfgUtil.getValue("LIB_EPASS3003_LIN");
            }
            if (model.contains("Gemalto")) {
                return this.cfgUtil.getValue("LIB_GEMALTO_LIN");
            }
            if (model.contains("ACSCryptoMate")) {
                return this.cfgUtil.getValue("LIB_ACSCryptoMate_LIN");
            }
        }
        if (model.contains("Aladdin")) {
            return this.cfgUtil.getValue("LIB_ALADDIN_MAC");
        }
        if (model.contains("SafeNet")) {
            return this.cfgUtil.getValue("LIB_SAFENET_MAC");
        }
        if (model.contains("ePass2003")) {
            return this.cfgUtil.getValue("LIB_EPASS2003_MAC");
        }
        if (model.contains("ePass3003Auto")) {
            return this.cfgUtil.getValue("LIB_EPASS3003_MAC");
        }
        if (model.contains("Gemalto")) {
            return this.cfgUtil.getValue("LIB_GEMALTO_MAC");
        }
        if (model.contains("ACSCryptoMate")) {
            return this.cfgUtil.getValue("LIB_ACSCryptoMate_MAC");
        }
        return "";
    }

    public KeyStore loadTokenKeyStore(String ksPass, UserAgent userAgent, String activeProvider) throws Exception {
        KeyStore keyStore;
        block43: {
            Provider prov;
            SunPKCS11 sunPKCS112;
            File eTokenConf;
            int numProviders = 0;
            String tempDir = System.getProperty("java.io.tmpdir");
            if (!tempDir.endsWith(this.pathSeparator)) {
                tempDir = tempDir + this.pathSeparator;
            }
            boolean hayMod = false;
            int i = 1;
            do {
                String name = "eToken" + i;
                String configFilePath = tempDir + "eToken" + i + ".cfg";
                eTokenConf = new File(configFilePath);
                if (eTokenConf.exists()) {
                    SunPKCS11 sunPKCS11eToken;
                    Security.removeProvider("SunPKCS11-" + name);
                    if (Security.getProvider("SunPKCS11-" + name) == null) {
                        String path;
                        try {
                            path = eTokenConf.getCanonicalPath();
                        }
                        catch (Exception w) {
                            path = eTokenConf.getPath();
                        }
                        try {
                            sunPKCS11eToken = new SunPKCS11(path);
                            Security.addProvider(sunPKCS11eToken);
                        }
                        catch (ProviderException pe) {
                            sunPKCS11eToken = null;
                        }
                    } else {
                        sunPKCS11eToken = (SunPKCS11)Security.getProvider("SunPKCS11-" + name);
                    }
                    if (sunPKCS11eToken != null) {
                        hayMod = true;
                        Provider prov2 = Security.getProvider("SunPKCS11-" + name);
                        ++numProviders;
                        if (!prov2.getServices().isEmpty()) {
                            KeyStore keyStore2 = null;
                            try {
                                if (activeProvider.equals(prov2.getName()) || activeProvider.equals("")) {
                                    keyStore2 = KeyStore.getInstance("PKCS11", prov2);
                                    keyStore2.load(null, ksPass.toCharArray());
                                }
                            }
                            catch (Exception ioEx) {
                                if (ioEx.getCause() instanceof UnrecoverableKeyException || ioEx.getCause() instanceof FailedLoginException) {
                                    throw new StoreInvalidPasswordException(this.msgUtil.getValue("MSG_CONTRASENIA_INVALIDA"));
                                }
                                logger.log(Level.SEVERE, "Exception ", ioEx);
                            }
                            return keyStore2;
                        }
                    }
                }
                ++i;
            } while (eTokenConf.exists());
            Security.removeProvider("SunPKCS11-aladdin");
            Security.removeProvider("SunPKCS11-safenet");
            Security.removeProvider("SunPKCS11-epass2003");
            Security.removeProvider("SunPKCS11-epass3003");
            Security.removeProvider("SunPKCS11-gemalto");
            Security.removeProvider("SunPKCS11-aCSCryptoMate");
            PKCS11ConfigFile f = new PKCS11ConfigFile(this.cfgUtil);
            String configFilePathAladdin = tempDir + "aladdin.cfg";
            PKCS11 sunPKCSAlladin = f.createConfigFile(configFilePathAladdin, "aladdin", userAgent);
            f = new PKCS11ConfigFile(this.cfgUtil);
            String configFilePathSafenet = tempDir + "safenet.cfg";
            PKCS11 sunPKCSSafenet = f.createConfigFile(configFilePathSafenet, "safenet", userAgent);
            f = new PKCS11ConfigFile(this.cfgUtil);
            String configFilePathEPass2003 = tempDir + "epass2003.cfg";
            PKCS11 sunPKCSEpass2003 = f.createConfigFile(configFilePathEPass2003, "epass2003", userAgent);
            f = new PKCS11ConfigFile(this.cfgUtil);
            String configFilePathEPass3003 = tempDir + "epass3003.cfg";
            PKCS11 sunPKCSEpass3003auto = f.createConfigFile(configFilePathEPass3003, "epass3003", userAgent);
            f = new PKCS11ConfigFile(this.cfgUtil);
            String configFilePathGemalto = tempDir + "gemalto.cfg";
            PKCS11 sunPKCSGemalto = f.createConfigFile(configFilePathGemalto, "gemalto", userAgent);
            f = new PKCS11ConfigFile(this.cfgUtil);
            String configFilePathCryptoMate = tempDir + "aCSCryptoMate.cfg";
            PKCS11 sunPKCSACSCryptoMate = f.createConfigFile(configFilePathCryptoMate, "aCSCryptoMate", userAgent);
            if (!hayMod && sunPKCSAlladin == null && sunPKCSSafenet == null && sunPKCSEpass2003 == null && sunPKCSEpass3003auto == null && sunPKCSGemalto == null && sunPKCSACSCryptoMate == null) {
                throw new DriverException("No se han encontrado dispositivos instalados");
            }
            keyStore = null;
            Provider provConect = null;
            if (sunPKCSAlladin != null) {
                try {
                    sunPKCS112 = new SunPKCS11(configFilePathAladdin);
                    Security.addProvider(sunPKCS112);
                    prov = Security.getProvider("SunPKCS11-aladdin");
                    if (prov != null && (activeProvider.equals(prov.getName()) || activeProvider.equals("")) && !prov.getServices().isEmpty()) {
                        provConect = prov;
                    }
                }
                catch (Exception sunPKCS112) {
                    // empty catch block
                }
            }
            if (sunPKCSSafenet != null) {
                try {
                    sunPKCS112 = new SunPKCS11(configFilePathSafenet);
                    Security.addProvider(sunPKCS112);
                    prov = Security.getProvider("SunPKCS11-safenet");
                    if (prov != null && (activeProvider.equals(prov.getName()) || activeProvider.equals("")) && !prov.getServices().isEmpty()) {
                        provConect = prov;
                    }
                }
                catch (Exception sunPKCS113) {
                    // empty catch block
                }
            }
            if (sunPKCSEpass2003 != null) {
                try {
                    sunPKCS112 = new SunPKCS11(configFilePathEPass2003);
                    Security.addProvider(sunPKCS112);
                    prov = Security.getProvider("SunPKCS11-epass2003");
                    if (prov != null && (activeProvider.equals(prov.getName()) || activeProvider.equals("")) && !prov.getServices().isEmpty()) {
                        provConect = prov;
                    }
                }
                catch (Exception sunPKCS114) {
                    // empty catch block
                }
            }
            if (sunPKCSEpass3003auto != null) {
                try {
                    sunPKCS112 = new SunPKCS11(configFilePathEPass3003);
                    Security.addProvider(sunPKCS112);
                    prov = Security.getProvider("SunPKCS11-epass3003");
                    if (prov != null && (activeProvider.equals(prov.getName()) || activeProvider.equals("")) && !prov.getServices().isEmpty()) {
                        provConect = prov;
                    }
                }
                catch (Exception sunPKCS115) {
                    // empty catch block
                }
            }
            if (sunPKCSGemalto != null) {
                try {
                    sunPKCS112 = new SunPKCS11(configFilePathGemalto);
                    Security.addProvider(sunPKCS112);
                    prov = Security.getProvider("SunPKCS11-gemalto");
                    if (prov != null && (activeProvider.equals(prov.getName()) || activeProvider.equals("")) && !prov.getServices().isEmpty()) {
                        provConect = prov;
                    }
                }
                catch (Exception sunPKCS116) {
                    // empty catch block
                }
            }
            if (sunPKCSACSCryptoMate != null) {
                try {
                    sunPKCS112 = new SunPKCS11(configFilePathCryptoMate);
                    Security.addProvider(sunPKCS112);
                    prov = Security.getProvider("SunPKCS11-aCSCryptoMate");
                    if (prov != null && (activeProvider.equals(prov.getName()) || activeProvider.equals("")) && !prov.getServices().isEmpty()) {
                        provConect = prov;
                    }
                }
                catch (Exception sunPKCS117) {
                    // empty catch block
                }
            }
            if (provConect == null) {
                throw new DriverException("No se han encontrado dispositivos conectados");
            }
            try {
                keyStore = KeyStore.getInstance("PKCS11", provConect);
                keyStore.load(null, ksPass.toCharArray());
            }
            catch (Exception ioEx) {
                logger.log(Level.SEVERE, "Exception ", ioEx);
                if (!(ioEx.getCause() instanceof UnrecoverableKeyException) && !(ioEx.getCause() instanceof FailedLoginException)) break block43;
                throw new StoreInvalidPasswordException(this.msgUtil.getValue("MSG_CONTRASENIA_INVALIDA"));
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadJKSKeyStore(String ksPass, String pathKeystore) throws Exception {
        File f = new File(pathKeystore);
        FileInputStream inStream = new FileInputStream(f);
        try {
            KeyStore keyStorePKCS12 = KeyStore.getInstance("PKCS12");
            keyStorePKCS12.load(inStream, ksPass.toCharArray());
            KeyStore keyStore = keyStorePKCS12;
            return keyStore;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception ", e);
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "IOException ", ex);
                }
            }
        }
    }

    public Provider getActiveProvider() {
        Provider prov;
        File eTokenConf;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(this.pathSeparator)) {
            tempDir = tempDir + this.pathSeparator;
        }
        int i = 1;
        Provider provConect = null;
        do {
            String name = "eToken" + i;
            String configFilePath = tempDir + "eToken" + i + ".cfg";
            eTokenConf = new File(configFilePath);
            if (!eTokenConf.exists()) continue;
            if (Security.getProvider("SunPKCS11-" + name) != null && !(prov = Security.getProvider("SunPKCS11-" + name)).getServices().isEmpty()) {
                provConect = prov;
            }
            ++i;
        } while (eTokenConf.exists());
        if (Security.getProvider("SunPKCS11-aladdin") != null && !(prov = Security.getProvider("SunPKCS11-aladdin")).getServices().isEmpty()) {
            provConect = prov;
        }
        if (Security.getProvider("SunPKCS11-safenet") != null && !(prov = Security.getProvider("SunPKCS11-safenet")).getServices().isEmpty()) {
            provConect = prov;
        }
        if (Security.getProvider("SunPKCS11-epass2003") != null && !(prov = Security.getProvider("SunPKCS11-epass2003")).getServices().isEmpty()) {
            provConect = prov;
        }
        if (Security.getProvider("SunPKCS11-epass3003auto") != null && !(prov = Security.getProvider("SunPKCS11-epass3003auto")).getServices().isEmpty()) {
            provConect = prov;
        }
        if (Security.getProvider("SunPKCS11-gemalto") != null && !(prov = Security.getProvider("SunPKCS11-gemalto")).getServices().isEmpty()) {
            provConect = prov;
        }
        if (Security.getProvider("SunPKCS11-gemalto") != null && !(prov = Security.getProvider("SunPKCS11-gemalto")).getServices().isEmpty()) {
            provConect = prov;
        }
        if (Security.getProvider("SunPKCS11-aCSCryptoMate") != null && !(prov = Security.getProvider("SunPKCS11-aCSCryptoMate")).getServices().isEmpty()) {
            provConect = prov;
        }
        return provConect;
    }

    public int getNumProviders() {
        File eTokenConf;
        Provider prov = null;
        int activeProviders = 0;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(this.pathSeparator)) {
            tempDir = tempDir + this.pathSeparator;
        }
        int i = 1;
        do {
            String name = "eToken" + i;
            String configFilePath = tempDir + "eToken" + i + ".cfg";
            eTokenConf = new File(configFilePath);
            if (!eTokenConf.exists()) continue;
            if (Security.getProvider("SunPKCS11-" + name) != null && !(prov = Security.getProvider("SunPKCS11-" + name)).getServices().isEmpty()) {
                ++activeProviders;
            }
            ++i;
        } while (eTokenConf.exists());
        if (Security.getProvider("SunPKCS11-aladdin") != null && !(prov = Security.getProvider("SunPKCS11-aladdin")).getServices().isEmpty()) {
            ++activeProviders;
        }
        if (Security.getProvider("SunPKCS11-safenet") != null && !(prov = Security.getProvider("SunPKCS11-safenet")).getServices().isEmpty()) {
            ++activeProviders;
        }
        if (Security.getProvider("SunPKCS11-epass2003") != null && !(prov = Security.getProvider("SunPKCS11-epass2003")).getServices().isEmpty()) {
            ++activeProviders;
        }
        if (Security.getProvider("SunPKCS11-epass3003auto") != null && !(prov = Security.getProvider("SunPKCS11-epass3003auto")).getServices().isEmpty()) {
            ++activeProviders;
        }
        if (Security.getProvider("SunPKCS11-aCSCryptoMate") != null && !(prov = Security.getProvider("SunPKCS11-aCSCryptoMate")).getServices().isEmpty()) {
            ++activeProviders;
        }
        return activeProviders;
    }

    public File buscarArchivoConfiguracion(String nombre) {
        File[] roots = File.listRoots();
        File etokenConfig = null;
        if (roots != null) {
            SofisFilenameFilter filter = new SofisFilenameFilter(nombre);
            for (int i = 0; i < roots.length && etokenConfig == null; ++i) {
                File[] files = roots[i].listFiles(filter);
                if (files == null || files.length <= 0) continue;
                etokenConfig = files[0];
            }
        }
        return etokenConfig;
    }

    private class SofisFilenameFilter
    implements FilenameFilter {
        String nombre = null;

        public SofisFilenameFilter(String nombre) {
            if (nombre != null) {
                this.nombre = nombre;
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.nombre != null && this.nombre.equals(name);
        }
    }

    class MyCallbackHandler
    implements CallbackHandler {
        MyCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        }
    }
}

