/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.utils;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class ProgressBarTableCellCustom<S>
extends TableCell<S, Double> {
    private final ProgressBar progressBar;
    private final Label lblProgress;
    private ObservableValue<Double> observable;

    public static <S> Callback<TableColumn<S, Double>, TableCell<S, Double>> forTableColumn() {
        return param -> new ProgressBarTableCellCustom();
    }

    public ProgressBarTableCellCustom() {
        this.getStyleClass().add((Object)"progress-bar-table-cell");
        this.progressBar = new ProgressBar();
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        this.lblProgress = new Label();
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.progressBar.progressProperty().unbind();
            TableColumn column = this.getTableColumn();
            ObservableValue<Double> observableValue = this.observable = column == null ? null : column.getCellObservableValue(this.getIndex());
            if (this.observable != null) {
                this.progressBar.progressProperty().bind(this.observable);
                this.lblProgress.setText((Double)this.observable.getValue() == -1.0 ? "0.00%" : String.valueOf((Double)this.observable.getValue() * 100.0) + "%");
            } else if (item != null) {
                this.progressBar.setProgress(item * 1000.0);
                this.lblProgress.setText(item == -1.0 ? "0.00%" : String.valueOf(item * 100.0) + "%");
            }
            this.lblProgress.setStyle("-fx-text-fill: white; -fx-font-family: sans-serif;");
            StackPane stackPaneProgressBar = new StackPane(new Node[]{this.progressBar, this.lblProgress});
            this.setGraphic((Node)stackPaneProgressBar);
        }
    }
}

