/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.pkcs11;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.IPassStoreKS;
import es.mityc.javasign.pkstore.pkcs11.ConfigMultiPKCS11;
import es.mityc.javasign.pkstore.pkcs11.IModuleData;
import es.mityc.javasign.pkstore.pkcs11.IProviderData;
import es.mityc.javasign.pkstore.pkcs11.P11CertificateProxy;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPKCS11Store
implements IPKStoreManager {
    private static final Log LOG = LogFactory.getLog(MultiPKCS11Store.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private ArrayList<IModuleData> providers = null;
    private IPassStoreKS passHandler = null;

    public MultiPKCS11Store(ConfigMultiPKCS11 config, IPassStoreKS passwordHandler) {
        List<IModuleData> list;
        this.passHandler = passwordHandler;
        this.providers = new ArrayList();
        if (config != null && (list = config.getProviders()) != null) {
            for (IModuleData pd : list) {
                this.providers.add(pd);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)I18N.getLocalMessage("i18n.mityc.cert.p11.9", new Object[]{pd.getName()}));
            }
        }
    }

    private void updateModules() {
        for (IModuleData providerData : this.providers) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)I18N.getLocalMessage("i18n.mityc.cert.p11.10", new Object[]{providerData.getName()}));
            }
            providerData.updateModule();
        }
    }

    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.p11.6"));
    }

    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        if (certificate instanceof P11CertificateProxy) {
            Provider provider = ((P11CertificateProxy)certificate).getProvider();
            try {
                KeyStore.PrivateKeyEntry pkEntry;
                KeyStore.LoadStoreParameter passwordHnd = new KeyStore.LoadStoreParameter(){

                    public KeyStore.ProtectionParameter getProtectionParameter() {
                        return new KeyStore.CallbackHandlerProtection(new InternCallbackHandlerProtection(MultiPKCS11Store.this.passHandler));
                    }
                };
                KeyStore ks = KeyStore.getInstance("PKCS11", provider);
                ks.load(passwordHnd);
                String alias = ks.getCertificateAlias(((P11CertificateProxy)certificate).getInternalCertificate());
                if (ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) && (pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.CallbackHandlerProtection(new InternCallbackHandlerProtection(this.passHandler)))) != null) {
                    return pkEntry.getPrivateKey();
                }
            }
            catch (KeyStoreException ex) {
            }
            catch (CertificateException ex) {
            }
            catch (NoSuchAlgorithmException ex) {
            }
            catch (IOException ex) {
            }
            catch (UnrecoverableEntryException unrecoverableEntryException) {
                // empty catch block
            }
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.p11.5"));
        }
        throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.p11.4"));
    }

    public Provider getProvider(X509Certificate cert) {
        Provider prov = null;
        if (cert instanceof P11CertificateProxy) {
            prov = ((P11CertificateProxy)cert).getProvider();
        }
        return prov;
    }

    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        this.updateModules();
        for (IModuleData providerData : this.providers) {
            for (IProviderData provider : providerData.getProvidersData()) {
                try {
                    KeyStore.LoadStoreParameter passwordHnd = new KeyStore.LoadStoreParameter(){

                        public KeyStore.ProtectionParameter getProtectionParameter() {
                            return new KeyStore.CallbackHandlerProtection(new InternCallbackHandlerProtection(MultiPKCS11Store.this.passHandler));
                        }
                    };
                    KeyStore ks = KeyStore.getInstance(provider.getKeyStoreTypeName(), provider.getProvider());
                    ks.load(passwordHnd);
                    Enumeration<String> aliases = ks.aliases();
                    while (aliases.hasMoreElements()) {
                        Certificate cert;
                        String alias = aliases.nextElement();
                        if (!ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || !((cert = ks.getCertificate(alias)) instanceof X509Certificate)) continue;
                        certificates.add(new P11CertificateProxy((X509Certificate)cert, provider.getProvider()));
                    }
                }
                catch (KeyStoreException ex) {
                }
                catch (CertificateException ex) {
                }
                catch (NoSuchAlgorithmException ex) {
                }
                catch (IOException ex) {
                }
            }
        }
        return certificates;
    }

    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.p11.6"));
    }

    protected class InternCallbackHandlerProtection
    implements CallbackHandler {
        private IPassStoreKS passHandler;

        public InternCallbackHandlerProtection(IPassStoreKS passwordHandler) {
            this.passHandler = passwordHandler;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (this.passHandler == null || !(callbacks[i] instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i], I18N.getLocalMessage("i18n.mityc.cert.p11.3"));
                }
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.passHandler.getPassword(null, pc.getPrompt()));
            }
        }
    }
}

