/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.commands;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.ImageReference;
import org.icepdf.core.pobjects.graphics.OptionalContentState;
import org.icepdf.core.pobjects.graphics.PaintTimer;
import org.icepdf.core.pobjects.graphics.commands.AbstractDrawCmd;
import org.icepdf.core.util.Defs;

public class ImageDrawCmd
extends AbstractDrawCmd {
    private static boolean isScaledPaint = Defs.booleanProperty("org.icepdf.core.imageDrawCmd.scale.enabled", false);
    public static int MIN_DIMENSION = Defs.intProperty("org.icepdf.core.imageDrawCmd.maxDimension", 5);
    private ImageReference image;
    private int xScale = 1;
    private int yScale = 1;
    private boolean xIsScale = false;
    private boolean yIsScale = false;
    private static final double[][] SCALE_LOOKUP = new double[][]{{1.5, 2.0}, {0.7, 3.0}, {0.4, 4.0}, {0.3, 6.0}, {0.2, 8.0}, {0.1, 10.0}, {0.05, 12.0}};

    public ImageDrawCmd(ImageReference image) {
        this.image = image;
        if (isScaledPaint) {
            if (image.getHeight() <= MIN_DIMENSION) {
                this.yIsScale = true;
            }
            if (image.getWidth() <= MIN_DIMENSION) {
                this.xIsScale = true;
            }
        }
    }

    public Image getImage() {
        return this.image.getImage();
    }

    public Shape paintOperand(Graphics2D g, Page parentPage, Shape currentShape, Shape clip, AffineTransform base, OptionalContentState optionalContentState, boolean paintAlpha, PaintTimer paintTimer) {
        if (optionalContentState.isVisible()) {
            if (isScaledPaint && (this.xIsScale || this.yIsScale)) {
                this.calculateThinScale(base.getScaleX());
            }
            this.image.drawImage(g, 0, 0, this.xScale, this.yScale);
            if (parentPage != null && paintTimer.shouldTriggerRepaint()) {
                parentPage.notifyPaintPageListeners();
            }
        }
        return currentShape;
    }

    private void calculateThinScale(double scale) {
        if (this.xIsScale) {
            this.xScale = this.commonScaling(scale, this.image.getWidth());
        }
        if (this.yIsScale) {
            this.yScale = this.commonScaling(scale, this.image.getHeight());
        }
    }

    private int commonScaling(double scale, int size) {
        for (int i = SCALE_LOOKUP.length - 1; i >= 0; --i) {
            if (!(scale < SCALE_LOOKUP[i][0])) continue;
            double neededSize = SCALE_LOOKUP[i][1];
            double scaleFactor = neededSize / (double)size;
            return (int)Math.ceil(scaleFactor);
        }
        return 1;
    }
}

