/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import org.w3c.dom.Element;
import xades4j.XAdES4jException;
import xades4j.production.DataObjectReference;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.production.PropertyDataGenerationException;
import xades4j.production.PropertyDataObjectGenerator;
import xades4j.production.SignedDataObjects;
import xades4j.production.XadesSigner;
import xades4j.properties.CounterSignatureProperty;
import xades4j.properties.data.GenericDOMData;
import xades4j.properties.data.PropertyDataObject;
import xades4j.utils.DOMHelper;

class DataGenCounterSig
implements PropertyDataObjectGenerator<CounterSignatureProperty> {
    DataGenCounterSig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyDataObject generatePropertyData(CounterSignatureProperty prop, PropertiesDataGenerationContext ctx) throws PropertyDataGenerationException {
        Element qPs = DOMHelper.getFirstDescendant(ctx.getTargetXmlSignature().getElement(), "http://uri.etsi.org/01903/v1.3.2#", "QualifyingProperties");
        Element counterSigElem = ctx.createElementInSignatureDoc("CounterSignature", qPs.getPrefix(), "http://uri.etsi.org/01903/v1.3.2#");
        qPs.appendChild(counterSigElem);
        try {
            Element sigValueElem = DOMHelper.getFirstDescendant(ctx.getTargetXmlSignature().getElement(), "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            String sigValueId = sigValueElem.getAttribute("Id");
            DataObjectReference sigValueRef = new DataObjectReference('#' + sigValueId).withType("http://uri.etsi.org/01903#CountersignedSignature");
            XadesSigner counterSigner = prop.getCounterSigSigner();
            if (null == counterSigner) {
                throw new PropertyDataGenerationException(prop, "signer not specified");
            }
            try {
                SignedDataObjects objs = prop.getSignedDataObjectsForCounterSig();
                if (null == objs) {
                    objs = new SignedDataObjects();
                }
                objs.withSignedDataObject(sigValueRef);
                counterSigner.sign(objs, counterSigElem);
            }
            catch (XAdES4jException ex) {
                throw new PropertyDataGenerationException(prop, "cannot apply counter signature", ex);
            }
        }
        finally {
            qPs.removeChild(counterSigElem);
        }
        return new GenericDOMData(counterSigElem);
    }
}

