/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import org.w3c.dom.Element;
import xades4j.XAdES4jException;
import xades4j.algorithms.EnvelopedSignatureTransform;
import xades4j.production.DataObjectReference;
import xades4j.production.SignedDataObjects;
import xades4j.production.XadesSigner;
import xades4j.properties.DataObjectDesc;

public class Enveloped {
    private final XadesSigner signer;

    public Enveloped(XadesSigner signer) {
        this.signer = signer;
    }

    public void sign(Element elementToSign) throws XAdES4jException {
        String refUri;
        if (elementToSign.hasAttribute("Id")) {
            refUri = '#' + elementToSign.getAttribute("Id");
        } else {
            if (elementToSign.getParentNode().getNodeType() != 9) {
                throw new IllegalArgumentException("Element without Id must be the document root");
            }
            refUri = "";
        }
        DataObjectDesc dataObjRef = new DataObjectReference(refUri).withTransform(new EnvelopedSignatureTransform());
        this.signer.sign(new SignedDataObjects(dataObjRef), elementToSign);
    }
}

