/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import xades4j.UnsupportedAlgorithmException;
import xades4j.production.KeyingDataException;
import xades4j.production.SigningCertKeyUsageException;
import xades4j.production.SigningCertValidityException;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.BasicSignatureOptionsProvider;

class KeyInfoBuilder {
    private final BasicSignatureOptionsProvider basicSignatureOptionsProvider;
    private final AlgorithmsProviderEx algorithmsProvider;

    KeyInfoBuilder(BasicSignatureOptionsProvider basicSignatureOptionsProvider, AlgorithmsProviderEx algorithmsProvider) {
        this.basicSignatureOptionsProvider = basicSignatureOptionsProvider;
        this.algorithmsProvider = algorithmsProvider;
    }

    void buildKeyInfo(X509Certificate signingCertificate, XMLSignature xmlSig) throws KeyingDataException, UnsupportedAlgorithmException {
        boolean[] keyUsage = signingCertificate.getKeyUsage();
        if (keyUsage != null && !keyUsage[0] && !keyUsage[1]) {
            throw new SigningCertKeyUsageException(signingCertificate);
        }
        try {
            signingCertificate.checkValidity();
        }
        catch (CertificateException ce) {
            throw new SigningCertValidityException(signingCertificate);
        }
        if (this.basicSignatureOptionsProvider.includeSigningCertificate()) {
            try {
                xmlSig.addKeyInfo(signingCertificate);
                if (this.basicSignatureOptionsProvider.signSigningCertificate()) {
                    String keyInfoId = xmlSig.getId() + "-keyinfo";
                    xmlSig.getKeyInfo().setId(keyInfoId);
                    xmlSig.addDocument('#' + keyInfoId, null, this.algorithmsProvider.getDigestAlgorithmForDataObjsReferences());
                }
            }
            catch (XMLSignatureException ex) {
                throw new UnsupportedAlgorithmException("Digest algorithm not supported in the XML Signature provider", this.algorithmsProvider.getDigestAlgorithmForDataObjsReferences(), ex);
            }
            catch (XMLSecurityException ex) {
                throw new KeyingDataException(ex.getMessage(), ex);
            }
        }
        if (this.basicSignatureOptionsProvider.includePublicKey()) {
            xmlSig.addKeyInfo(signingCertificate.getPublicKey());
        }
    }
}

