/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.production.PropertiesDataObjectsGenerator;
import xades4j.production.PropertyDataGenerationException;
import xades4j.production.PropertyDataGeneratorErrorException;
import xades4j.production.PropertyDataGeneratorsMapper;
import xades4j.production.PropertyDataObjectGenerator;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.SignedProperties;
import xades4j.properties.UnsignedProperties;
import xades4j.properties.data.PropertiesDataObjectsStructureVerifier;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.PropertyDataStructureException;
import xades4j.properties.data.SigAndDataObjsPropertiesData;
import xades4j.utils.SigAndDataObjPropsPair;

class PropertiesDataObjectsGeneratorImpl
implements PropertiesDataObjectsGenerator {
    private final PropertyDataGeneratorsMapper propsDataGensMapper;
    private final PropertiesDataObjectsStructureVerifier dataObjectsStructureVerifier;

    @Inject
    PropertiesDataObjectsGeneratorImpl(PropertyDataGeneratorsMapper propsDataGensMapper, PropertiesDataObjectsStructureVerifier dataObjectsStructureVerifier) {
        this.propsDataGensMapper = propsDataGensMapper;
        this.dataObjectsStructureVerifier = dataObjectsStructureVerifier;
    }

    @Override
    public SigAndDataObjsPropertiesData generateSignedPropertiesData(SignedProperties signedProps, PropertiesDataGenerationContext ctx) throws PropertyDataGenerationException, PropertyDataStructureException {
        return this.genPropsData(signedProps, ctx);
    }

    @Override
    public SigAndDataObjsPropertiesData generateUnsignedPropertiesData(UnsignedProperties unsignedProps, PropertiesDataGenerationContext ctx) throws PropertyDataGenerationException, PropertyDataStructureException {
        return this.genPropsData(unsignedProps, ctx);
    }

    private SigAndDataObjsPropertiesData genPropsData(SigAndDataObjPropsPair<? extends QualifyingProperty, ? extends QualifyingProperty> props, PropertiesDataGenerationContext ctx) throws PropertyDataGenerationException, PropertyDataStructureException {
        return new SigAndDataObjsPropertiesData(this.doGenPropsData(props.getSigProps(), ctx), this.doGenPropsData(props.getDataObjProps(), ctx));
    }

    private <TProp extends QualifyingProperty> Collection<PropertyDataObject> doGenPropsData(Collection<TProp> props, PropertiesDataGenerationContext ctx) throws PropertyDataGenerationException, PropertyDataStructureException {
        ArrayList<PropertyDataObject> propsData = new ArrayList<PropertyDataObject>(props.size());
        for (QualifyingProperty p : props) {
            PropertyDataObjectGenerator<QualifyingProperty> dataGen = this.propsDataGensMapper.getGenerator(p);
            PropertyDataObject pData = dataGen.generatePropertyData(p, ctx);
            if (null == pData) {
                throw new PropertyDataGeneratorErrorException(p);
            }
            propsData.add(pData);
        }
        this.dataObjectsStructureVerifier.verifiyPropertiesDataStructure(propsData);
        return propsData;
    }
}

