/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import xades4j.production.SignaturePropertiesCollectorImpl;
import xades4j.production.SignedDataObjects;
import xades4j.properties.DataObjectDesc;
import xades4j.properties.QualifyingProperties;
import xades4j.properties.SignedDataObjectProperty;
import xades4j.properties.SignedProperties;
import xades4j.properties.SignedSignatureProperty;
import xades4j.properties.UnsignedDataObjectProperty;
import xades4j.properties.UnsignedProperties;
import xades4j.properties.UnsignedSignatureProperty;
import xades4j.providers.DataObjectPropertiesProvider;
import xades4j.providers.SignaturePropertiesProvider;

class QualifyingPropertiesProcessor {
    private final SignaturePropertiesProvider sigPropsProvider;
    private final DataObjectPropertiesProvider dataObjPropsProvider;

    public QualifyingPropertiesProcessor(SignaturePropertiesProvider sigPropsProvider, DataObjectPropertiesProvider dataObjPropsProvider) {
        this.sigPropsProvider = sigPropsProvider;
        this.dataObjPropsProvider = dataObjPropsProvider;
    }

    QualifyingProperties getQualifyingProperties(SignedDataObjects dataObjs, Collection<SignedSignatureProperty> formatSpecificSignedSigProps, Collection<UnsignedSignatureProperty> formatSpecificUnsignedSigProps) {
        SignaturePropertiesCollectorImpl signaturePropsCollector = new SignaturePropertiesCollectorImpl();
        this.sigPropsProvider.provideProperties(signaturePropsCollector);
        Collection<SignedSignatureProperty> collectedSignedSigProps = signaturePropsCollector.getSignedSigProps();
        ArrayList<SignedSignatureProperty> signedSigProps = new ArrayList<SignedSignatureProperty>(collectedSignedSigProps.size() + formatSpecificSignedSigProps.size());
        signedSigProps.addAll(collectedSignedSigProps);
        signedSigProps.addAll(formatSpecificSignedSigProps);
        Collection<UnsignedSignatureProperty> collectedUnsignedSigProps = signaturePropsCollector.getUnsignedSigProps();
        ArrayList<UnsignedSignatureProperty> unsignedSigProps = new ArrayList<UnsignedSignatureProperty>(collectedUnsignedSigProps.size() + formatSpecificUnsignedSigProps.size());
        unsignedSigProps.addAll(collectedUnsignedSigProps);
        unsignedSigProps.addAll(formatSpecificUnsignedSigProps);
        Collection<DataObjectDesc> dataObjsInfo = dataObjs.getDataObjectsDescs();
        HashSet<SignedDataObjectProperty> signedDataObjProps = new HashSet<SignedDataObjectProperty>(dataObjsInfo.size());
        HashSet<UnsignedDataObjectProperty> unsignedDataObjProps = new HashSet<UnsignedDataObjectProperty>(0);
        signedDataObjProps.addAll(dataObjs.getSignedDataObjsProperties());
        unsignedDataObjProps.addAll(dataObjs.getUnsignedDataObjsProperties());
        for (DataObjectDesc dataObjInfo : dataObjsInfo) {
            if (!dataObjInfo.hasProperties()) {
                this.dataObjPropsProvider.provideProperties(dataObjInfo);
            }
            signedDataObjProps.addAll(dataObjInfo.getSignedDataObjProps());
            unsignedDataObjProps.addAll(dataObjInfo.getUnsignedDataObjProps());
        }
        return new QualifyingProperties(new SignedProperties((Collection<SignedSignatureProperty>)signedSigProps, (Collection<SignedDataObjectProperty>)signedDataObjProps), new UnsignedProperties((Collection<UnsignedSignatureProperty>)unsignedSigProps, (Collection<UnsignedDataObjectProperty>)unsignedDataObjProps));
    }
}

