/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.HashMap;
import xades4j.UnsupportedAlgorithmException;
import xades4j.providers.MessageDigestEngineProvider;

public class DefaultMessageDigestProvider
implements MessageDigestEngineProvider {
    private static final HashMap<String, String> algorithmMapper = new HashMap(4);
    private final String messageDigestProvider;

    public DefaultMessageDigestProvider(String messageDigestProvider) throws NoSuchProviderException {
        if (null == messageDigestProvider) {
            throw new NullPointerException("Message digest provider cannot be null");
        }
        if (Security.getProvider(messageDigestProvider) == null) {
            throw new NoSuchProviderException(messageDigestProvider);
        }
        this.messageDigestProvider = messageDigestProvider;
    }

    public DefaultMessageDigestProvider() {
        this.messageDigestProvider = null;
    }

    @Override
    public MessageDigest getEngine(String digestAlgorithmURI) throws UnsupportedAlgorithmException {
        String digestAlgorithmName = algorithmMapper.get(digestAlgorithmURI);
        if (null == digestAlgorithmName) {
            throw new UnsupportedAlgorithmException("Digest algorithm not supported by the provider", digestAlgorithmURI);
        }
        try {
            return this.messageDigestProvider == null ? MessageDigest.getInstance(digestAlgorithmName) : MessageDigest.getInstance(digestAlgorithmName, this.messageDigestProvider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new UnsupportedAlgorithmException(nsae.getMessage(), digestAlgorithmURI, nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new UnsupportedAlgorithmException("Provider not available", digestAlgorithmURI, nspe);
        }
    }

    static {
        algorithmMapper.put("http://www.w3.org/2000/09/xmldsig#sha1", "SHA-1");
        algorithmMapper.put("http://www.w3.org/2001/04/xmlenc#sha256", "SHA-256");
        algorithmMapper.put("http://www.w3.org/2001/04/xmldsig-more#sha384", "SHA-384");
        algorithmMapper.put("http://www.w3.org/2001/04/xmlenc#sha512", "SHA-512");
    }
}

