/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.security.MessageDigest;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.security.auth.x500.X500Principal;
import xades4j.UnsupportedAlgorithmException;
import xades4j.XAdES4jException;
import xades4j.properties.data.CertRef;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.verification.SigningCertificateVerificationException;

class CertRefUtils {
    CertRefUtils() {
    }

    static CertRef findCertRef(X509Certificate cert, Collection<CertRef> certRefs) throws SigningCertificateVerificationException {
        for (final CertRef certRef : certRefs) {
            X500Principal certRefIssuerPrincipal;
            try {
                certRefIssuerPrincipal = new X500Principal(certRef.issuerDN);
            }
            catch (IllegalArgumentException ex) {
                throw new SigningCertificateVerificationException(ex){

                    @Override
                    protected String getVerificationMessage() {
                        return String.format("Invalid issue name: %s", certRef.issuerDN);
                    }
                };
            }
            if (!cert.getIssuerX500Principal().equals(certRefIssuerPrincipal) || !certRef.serialNumber.equals(cert.getSerialNumber())) continue;
            return certRef;
        }
        return null;
    }

    static void checkCertRef(CertRef certRef, X509Certificate cert, MessageDigestEngineProvider messageDigestProvider) throws InvalidCertRefException {
        Exception t = null;
        try {
            MessageDigest messageDigest = messageDigestProvider.getEngine(certRef.digestAlgUri);
            byte[] actualDigest = messageDigest.digest(cert.getEncoded());
            if (!Arrays.equals(certRef.digestValue, actualDigest)) {
                throw new InvalidCertRefException("digests mismatch");
            }
            return;
        }
        catch (UnsupportedAlgorithmException ex) {
            t = ex;
        }
        catch (CertificateEncodingException ex) {
            t = ex;
        }
        throw new InvalidCertRefException(t.getMessage());
    }

    static class InvalidCertRefException
    extends XAdES4jException {
        public InvalidCertRefException(String msg) {
            super(msg);
        }
    }
}

