/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.util.Collection;
import xades4j.properties.AllDataObjsCommitmentTypeProperty;
import xades4j.properties.CommitmentTypeProperty;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.CommitmentTypeData;
import xades4j.verification.CommitmentTypeVerificationException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.RawDataObjectDesc;

class CommitmentTypeVerifier
implements QualifyingPropertyVerifier<CommitmentTypeData> {
    CommitmentTypeVerifier() {
    }

    @Override
    public QualifyingProperty verify(CommitmentTypeData propData, QualifyingPropertyVerificationContext ctx) throws CommitmentTypeVerificationException {
        String uri = propData.getUri();
        String desc = propData.getDescription();
        Collection<String> objsReferences = propData.getObjReferences();
        if (objsReferences != null) {
            QualifyingPropertyVerificationContext.SignedObjectsData signedObjsData = ctx.getSignedObjectsData();
            CommitmentTypeProperty commitmentTypeProperty = new CommitmentTypeProperty(uri, desc);
            for (String objRef : objsReferences) {
                RawDataObjectDesc dataObj = signedObjsData.findSignedDataObject(objRef);
                if (null == dataObj) {
                    throw new CommitmentTypeVerificationException(objRef);
                }
                dataObj.withCommitmentType(commitmentTypeProperty);
            }
            return commitmentTypeProperty;
        }
        return new AllDataObjsCommitmentTypeProperty(uri, desc);
    }
}

