/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import xades4j.UnsupportedAlgorithmException;
import xades4j.algorithms.Algorithm;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.properties.data.PropertyDataObject;
import xades4j.xml.bind.xades.XmlEncapsulatedPKIDataType;
import xades4j.xml.bind.xades.XmlXAdESTimeStampType;
import xades4j.xml.bind.xmldsig.XmlCanonicalizationMethodType;
import xades4j.xml.marshalling.QualifyingPropertyDataToXmlConverter;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

abstract class ToXmlBaseTimeStampConverter<TData extends BaseXAdESTimeStampData, TXml>
implements QualifyingPropertyDataToXmlConverter<TXml> {
    private final AlgorithmsParametersMarshallingProvider algorithmsParametersMarshallingProvider;

    protected ToXmlBaseTimeStampConverter(AlgorithmsParametersMarshallingProvider algorithmsParametersMarshallingProvider) {
        this.algorithmsParametersMarshallingProvider = algorithmsParametersMarshallingProvider;
    }

    @Override
    public final void convertIntoObjectTree(PropertyDataObject propData, TXml xmlProps, Document doc) {
        BaseXAdESTimeStampData tsData = (BaseXAdESTimeStampData)propData;
        XmlXAdESTimeStampType xmlTimeStamp = new XmlXAdESTimeStampType();
        XmlCanonicalizationMethodType xmlCanon = new XmlCanonicalizationMethodType();
        xmlTimeStamp.setCanonicalizationMethod(xmlCanon);
        Algorithm c14n = tsData.getCanonicalizationAlgorithm();
        xmlCanon.setAlgorithm(c14n.getUri());
        try {
            List<Node> c14nParams = this.algorithmsParametersMarshallingProvider.marshalParameters(c14n, doc);
            if (c14nParams != null) {
                xmlCanon.getContent().addAll(c14nParams);
            }
        }
        catch (UnsupportedAlgorithmException ex) {
            throw new IllegalArgumentException("Cannot marshall algorithm parameters", ex);
        }
        List<byte[]> tsTokens = tsData.getTimeStampTokens();
        List<Object> xmlTSTokens = xmlTimeStamp.getEncapsulatedTimeStampOrXMLTimeStamp();
        for (byte[] tsToken : tsTokens) {
            XmlEncapsulatedPKIDataType xmlTSTkn = new XmlEncapsulatedPKIDataType();
            xmlTSTkn.setValue(tsToken);
            xmlTSTokens.add(xmlTSTkn);
        }
        this.insertIntoObjectTree(xmlTimeStamp, xmlProps, tsData);
    }

    protected abstract void insertIntoObjectTree(XmlXAdESTimeStampType var1, TXml var2, TData var3);
}

