/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.marshalling.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import xades4j.algorithms.XPath2FilterTransform;
import xades4j.xml.marshalling.algorithms.AlgorithmParametersMarshaller;

final class XPath2FilterTransformParamsMarshaller
implements AlgorithmParametersMarshaller<XPath2FilterTransform> {
    XPath2FilterTransformParamsMarshaller() {
    }

    @Override
    public List<Node> marshalParameters(XPath2FilterTransform alg, Document doc) {
        List<XPath2FilterTransform.XPath2Filter> filters = alg.getFilters();
        ArrayList<Node> params = new ArrayList<Node>(filters.size());
        Set<Map.Entry<String, String>> namespaces = alg.getNamespaces().entrySet();
        for (XPath2FilterTransform.XPath2Filter filter : filters) {
            XPath2FilterContainer c = null;
            String filterType = filter.getFilterType();
            if ("intersect".equals(filterType)) {
                c = XPath2FilterContainer.newInstanceIntersect((Document)doc, (String)filter.getXPath());
            } else if ("subtract".equals(filterType)) {
                c = XPath2FilterContainer.newInstanceSubtract((Document)doc, (String)filter.getXPath());
            } else if ("union".equals(filterType)) {
                c = XPath2FilterContainer.newInstanceUnion((Document)doc, (String)filter.getXPath());
            } else {
                throw new IllegalArgumentException(filterType);
            }
            for (Map.Entry<String, String> ns : namespaces) {
                try {
                    c.setXPathNamespaceContext(ns.getKey(), ns.getValue());
                }
                catch (XMLSecurityException ex) {
                    throw new IllegalArgumentException("Invalid namespaces for XPath query", ex);
                }
            }
            params.add(c.getElement());
        }
        return params;
    }
}

