/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import java.util.List;
import xades4j.properties.data.CommitmentTypeData;
import xades4j.xml.bind.xades.XmlCommitmentTypeIndicationType;
import xades4j.xml.bind.xades.XmlSignedDataObjectPropertiesType;
import xades4j.xml.unmarshalling.PropertyUnmarshalException;
import xades4j.xml.unmarshalling.QualifyingPropertiesDataCollector;
import xades4j.xml.unmarshalling.SignedDataObjPropFromXmlConv;

class FromXmlCommitmentTypeConverter
implements SignedDataObjPropFromXmlConv {
    FromXmlCommitmentTypeConverter() {
    }

    @Override
    public void convertFromObjectTree(XmlSignedDataObjectPropertiesType xmlProps, QualifyingPropertiesDataCollector propertyDataCollector) throws PropertyUnmarshalException {
        List<XmlCommitmentTypeIndicationType> xmlCommitments = xmlProps.getCommitmentTypeIndication();
        if (xmlCommitments.isEmpty()) {
            return;
        }
        for (XmlCommitmentTypeIndicationType xmlCommitment : xmlCommitments) {
            List<String> objsRefs = xmlCommitment.getObjectReference();
            Object allDataObjs = xmlCommitment.getAllSignedDataObjects();
            if (objsRefs.isEmpty()) {
                objsRefs = null;
                if (null == allDataObjs) {
                    throw new PropertyUnmarshalException("ObjectReference or AllSignedDataObjects have to be present", "CommitmentTypeIndication");
                }
            } else if (allDataObjs != null) {
                throw new PropertyUnmarshalException("Both ObjectReference and AllSignedDataObjects are present", "CommitmentTypeIndication");
            }
            CommitmentTypeData commTypeData = new CommitmentTypeData(xmlCommitment.getCommitmentTypeId().getIdentifier().getValue(), xmlCommitment.getCommitmentTypeId().getDescription());
            commTypeData.setObjReferences(objsRefs);
            propertyDataCollector.addCommitmentType(commTypeData);
        }
    }
}

