/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMappingClassMapper;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigMappingProvider;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.Converter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ConfigMappingGenerator {
    static final boolean usefulDebugInfo = Boolean.parseBoolean(AccessController.doPrivileged(() -> System.getProperty("io.smallrye.config.mapper.useful-debug-info")));
    private static final String I_CLASS = Type.getInternalName(Class.class);
    private static final String I_COLLECTIONS = Type.getInternalName(Collections.class);
    private static final String I_CONFIGURATION_OBJECT = Type.getInternalName(ConfigMappingObject.class);
    private static final String I_CONVERTER = Type.getInternalName(Converter.class);
    private static final String I_MAP = Type.getInternalName(Map.class);
    private static final String I_MAPPING_CONTEXT = Type.getInternalName(ConfigMappingContext.class);
    private static final String I_OBJECT = Type.getInternalName(Object.class);
    private static final String I_OPTIONAL = Type.getInternalName(Optional.class);
    private static final String I_RUNTIME_EXCEPTION = Type.getInternalName(RuntimeException.class);
    private static final String I_SMALLRYE_CONFIG = Type.getInternalName(SmallRyeConfig.class);
    private static final String I_STRING_BUILDER = Type.getInternalName(StringBuilder.class);
    private static final String I_STRING = Type.getInternalName(String.class);
    private static final String I_FIELD = Type.getInternalName(Field.class);
    private static final int V_THIS = 0;
    private static final int V_MAPPING_CONTEXT = 1;
    private static final int V_STRING_BUILDER = 2;
    private static final int V_LENGTH = 3;

    static byte[] generate(ConfigMappingInterface mapping) {
        ClassWriter writer = new ClassWriter(3);
        Object visitor = usefulDebugInfo ? new Debugging.ClassVisitorImpl(writer) : writer;
        visitor.visit(52, 17, mapping.getClassInternalName(), null, I_OBJECT, new String[]{I_CONFIGURATION_OBJECT, Type.getInternalName(mapping.getInterfaceType())});
        visitor.visitSource(null, null);
        MethodVisitor ctor = visitor.visitMethod(1, "<init>", "(L" + I_MAPPING_CONTEXT + ";)V", null, null);
        ctor.visitParameter("context", 16);
        Label ctorStart = new Label();
        Label ctorEnd = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, I_OBJECT, "<init>", "()V", false);
        ctor.visitVarInsn(25, 1);
        ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getStringBuilder", "()L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(89);
        Label ctorSbStart = new Label();
        ctor.visitLabel(ctorSbStart);
        ctor.visitVarInsn(58, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
        Label ctorLenStart = new Label();
        ctor.visitLabel(ctorLenStart);
        ctor.visitVarInsn(54, 3);
        MethodVisitor fio = visitor.visitMethod(1, "fillInOptionals", "(L" + I_MAPPING_CONTEXT + ";)V", null, null);
        fio.visitParameter("context", 16);
        Label fioStart = new Label();
        Label fioEnd = new Label();
        fio.visitLabel(fioStart);
        fio.visitVarInsn(25, 1);
        fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getStringBuilder", "()L" + I_STRING_BUILDER + ';', false);
        fio.visitVarInsn(58, 2);
        ConfigMappingGenerator.addProperties((ClassVisitor)visitor, ctor, fio, new HashSet<String>(), mapping, mapping.getClassInternalName());
        fio.visitInsn(177);
        fio.visitLabel(fioEnd);
        fio.visitLocalVariable("mc", 'L' + I_MAPPING_CONTEXT + ';', null, fioStart, fioEnd, 1);
        fio.visitEnd();
        fio.visitMaxs(0, 0);
        ctor.visitInsn(177);
        ctor.visitLabel(ctorEnd);
        ctor.visitLocalVariable("mc", 'L' + I_MAPPING_CONTEXT + ';', null, ctorStart, ctorEnd, 1);
        ctor.visitLocalVariable("sb", 'L' + I_STRING_BUILDER + ';', null, ctorSbStart, ctorEnd, 2);
        ctor.visitLocalVariable("len", "I", null, ctorLenStart, ctorEnd, 3);
        ctor.visitEnd();
        ctor.visitMaxs(0, 0);
        visitor.visitEnd();
        return writer.toByteArray();
    }

    static byte[] generate(Class<?> classType, String interfaceName) {
        Field[] declaredFields;
        Object classInstance;
        String classInternalName = Type.getInternalName(classType);
        String interfaceInternalName = interfaceName.replace('.', '/');
        ClassWriter writer = new ClassWriter(3);
        writer.visit(52, 1537, interfaceInternalName, null, I_OBJECT, new String[]{Type.getInternalName(ConfigMappingClassMapper.class)});
        try {
            classInstance = classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (Field declaredField : declaredFields = classType.getDeclaredFields()) {
            AnnotationVisitor av;
            AnnotationVisitor av2;
            MethodVisitor mv = writer.visitMethod(1025, declaredField.getName(), Type.getMethodDescriptor((Type)Type.getType(declaredField.getType()), (Type[])new Type[0]), ConfigMappingGenerator.getSignature(declaredField), null);
            boolean hasDefault = false;
            if (declaredField.isAnnotationPresent(WithName.class)) {
                av2 = mv.visitAnnotation("L" + Type.getInternalName(WithName.class) + ";", true);
                av2.visit("value", (Object)declaredField.getAnnotation(WithName.class).value());
                av2.visitEnd();
            }
            if (declaredField.isAnnotationPresent(WithDefault.class)) {
                av2 = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                av2.visit("value", (Object)declaredField.getAnnotation(WithDefault.class).value());
                av2.visitEnd();
                hasDefault = true;
            }
            if (declaredField.isAnnotationPresent(WithConverter.class)) {
                av2 = mv.visitAnnotation("L" + Type.getInternalName(WithConverter.class) + ";", true);
                av2.visit("value", declaredField.getAnnotation(WithConverter.class).value());
                av2.visitEnd();
            }
            if (declaredField.isAnnotationPresent(ConfigProperty.class)) {
                ConfigProperty configProperty = declaredField.getAnnotation(ConfigProperty.class);
                if (!configProperty.name().isEmpty()) {
                    av = mv.visitAnnotation("L" + Type.getInternalName(WithName.class) + ";", true);
                    av.visit("value", (Object)configProperty.name());
                    av.visitEnd();
                }
                if (!configProperty.defaultValue().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                    av = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                    av.visit("value", (Object)configProperty.defaultValue());
                    av.visitEnd();
                    hasDefault = true;
                }
            }
            if (!hasDefault) {
                try {
                    declaredField.setAccessible(true);
                    Object defaultValue = declaredField.get(classInstance);
                    if (ConfigMappingGenerator.hasDefaultValue(declaredField.getType(), defaultValue)) {
                        av = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                        av.visit("value", (Object)defaultValue.toString());
                        av.visitEnd();
                    }
                }
                catch (IllegalAccessException defaultValue) {
                    // empty catch block
                }
            }
            mv.visitEnd();
        }
        MethodVisitor ctor = writer.visitMethod(1, "map", "()L" + I_OBJECT + ";", null, null);
        Label ctorStart = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitTypeInsn(187, classInternalName);
        ctor.visitInsn(89);
        ctor.visitMethodInsn(183, classInternalName, "<init>", "()V", false);
        ctor.visitVarInsn(58, 1);
        for (Field declaredField : declaredFields) {
            if (Modifier.isStatic(declaredField.getModifiers()) || Modifier.isVolatile(declaredField.getModifiers()) || Modifier.isFinal(declaredField.getModifiers())) continue;
            String name = declaredField.getName();
            Class<?> type = declaredField.getType();
            if (Modifier.isPublic(declaredField.getModifiers())) {
                ctor.visitVarInsn(25, 1);
                ctor.visitVarInsn(25, 0);
                ctor.visitMethodInsn(185, interfaceInternalName, name, Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[0]), true);
                ctor.visitFieldInsn(181, classInternalName, name, Type.getDescriptor(type));
                continue;
            }
            ctor.visitLdcInsn((Object)Type.getType(classType));
            ctor.visitLdcInsn((Object)name);
            ctor.visitMethodInsn(182, I_CLASS, "getDeclaredField", Type.getMethodDescriptor((Type)Type.getType(Field.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            ctor.visitVarInsn(58, 2);
            ctor.visitVarInsn(25, 2);
            ctor.visitInsn(4);
            ctor.visitMethodInsn(182, I_FIELD, "setAccessible", "(Z)V", false);
            ctor.visitVarInsn(25, 2);
            ctor.visitVarInsn(25, 1);
            ctor.visitVarInsn(25, 0);
            ctor.visitMethodInsn(185, interfaceInternalName, name, Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[0]), true);
            switch (Type.getType(type).getSort()) {
                case 1: {
                    ctor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    ctor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    ctor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 4: {
                    ctor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case 5: {
                    ctor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 6: {
                    ctor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 7: {
                    ctor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 8: {
                    ctor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                }
            }
            ctor.visitMethodInsn(182, I_FIELD, "set", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), false);
        }
        ctor.visitVarInsn(25, 1);
        ctor.visitInsn(176);
        ctor.visitMaxs(2, 2);
        writer.visitEnd();
        return writer.toByteArray();
    }

    static String generateInterfaceName(Class<?> classType) {
        if (classType.isInterface() && classType.getTypeParameters().length == 0 || Modifier.isAbstract(classType.getModifiers()) || classType.isEnum()) {
            throw new IllegalArgumentException();
        }
        return classType.getPackage().getName() + "." + classType.getSimpleName() + classType.getName().hashCode() + "I";
    }

    private static void addProperties(ClassVisitor cv, MethodVisitor ctor, MethodVisitor fio, Set<String> visited, ConfigMappingInterface mapping, String className) {
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            Label _done;
            Label _continue;
            Method method = property.getMethod();
            String memberName = method.getName();
            if (!visited.add(memberName)) continue;
            String fieldType = Type.getInternalName(method.getReturnType());
            String fieldDesc = Type.getDescriptor(method.getReturnType());
            cv.visitField(2, memberName, fieldDesc, null, null);
            boolean optional = property.isOptional();
            ConfigMappingInterface.Property realProperty = optional ? property.asOptional().getNestedProperty() : property;
            if (property.isMap()) {
                ctor.visitMethodInsn(184, I_COLLECTIONS, "emptyMap", "()L" + I_MAP + ';', false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitVarInsn(25, 1);
                fio.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                fio.visitLdcInsn((Object)memberName);
                fio.visitVarInsn(25, 0);
                fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getEnclosedField", "(L" + I_CLASS + ";L" + I_STRING + ";L" + I_OBJECT + ";)L" + I_OBJECT + ';', false);
                fio.visitInsn(89);
                _continue = new Label();
                _done = new Label();
                fio.visitJumpInsn(198, _continue);
                fio.visitTypeInsn(192, I_MAP);
                fio.visitVarInsn(25, 0);
                fio.visitInsn(95);
                fio.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitJumpInsn(167, _done);
                fio.visitLabel(_continue);
                fio.visitInsn(87);
                fio.visitLabel(_done);
            } else if (property.isGroup()) {
                boolean restoreLength = ConfigMappingGenerator.appendPropertyName(ctor, property, memberName);
                ctor.visitVarInsn(25, 1);
                ctor.visitLdcInsn((Object)Type.getType(realProperty.asGroup().getGroupType().getInterfaceType()));
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "constructGroup", "(L" + I_CLASS + ";)L" + I_OBJECT + ';', false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                if (restoreLength) {
                    ConfigMappingGenerator.restoreLength(ctor);
                }
            } else if (property.isLeaf() || property.isPrimitive() || property.isOptional() && property.isLeaf()) {
                ctor.visitVarInsn(25, 0);
                boolean restoreLength = ConfigMappingGenerator.appendPropertyName(ctor, property, memberName);
                ctor.visitVarInsn(25, 1);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getConfig", "()L" + I_SMALLRYE_CONFIG + ';', false);
                ctor.visitVarInsn(25, 2);
                ctor.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ';', false);
                ctor.visitVarInsn(25, 1);
                ctor.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                ctor.visitLdcInsn((Object)memberName);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getValueConverter", "(L" + I_CLASS + ";L" + I_STRING + ";)L" + I_CONVERTER + ';', false);
                Label _try = new Label();
                Label _catch = new Label();
                Label _continue2 = new Label();
                ctor.visitLabel(_try);
                if (property.isOptional()) {
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getOptionalValue", "(L" + I_STRING + ";L" + I_CONVERTER + ";)L" + I_OPTIONAL + ';', false);
                } else {
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getValue", "(L" + I_STRING + ";L" + I_CONVERTER + ";)L" + I_OBJECT + ';', false);
                }
                if (property.isPrimitive()) {
                    ConfigMappingInterface.PrimitiveProperty prim = property.asPrimitive();
                    String boxType = Type.getInternalName(prim.getBoxType());
                    ctor.visitTypeInsn(192, boxType);
                    ctor.visitMethodInsn(182, boxType, prim.getUnboxMethodName(), prim.getUnboxMethodDescriptor(), false);
                } else if (!property.isOptional()) {
                    assert (property.isLeaf());
                    ctor.visitTypeInsn(192, fieldType);
                }
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                ctor.visitJumpInsn(167, _continue2);
                ctor.visitLabel(_catch);
                ctor.visitVarInsn(25, 1);
                ctor.visitInsn(95);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "reportProblem", "(L" + I_RUNTIME_EXCEPTION + ";)V", false);
                ctor.visitLabel(_continue2);
                if (restoreLength) {
                    ConfigMappingGenerator.restoreLength(ctor);
                }
                ctor.visitTryCatchBlock(_try, _catch, _catch, I_RUNTIME_EXCEPTION);
            } else if (property.isOptional()) {
                ctor.visitMethodInsn(184, I_OPTIONAL, "empty", "()L" + I_OPTIONAL + ";", false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitVarInsn(25, 1);
                fio.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                fio.visitLdcInsn((Object)memberName);
                fio.visitVarInsn(25, 0);
                fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getEnclosedField", "(L" + I_CLASS + ";L" + I_STRING + ";L" + I_OBJECT + ";)L" + I_OBJECT + ';', false);
                fio.visitInsn(89);
                _continue = new Label();
                _done = new Label();
                fio.visitJumpInsn(198, _continue);
                fio.visitMethodInsn(184, I_OPTIONAL, "of", "(L" + I_OBJECT + ";)L" + I_OPTIONAL + ';', false);
                fio.visitVarInsn(25, 0);
                fio.visitInsn(95);
                fio.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitJumpInsn(167, _done);
                fio.visitLabel(_continue);
                fio.visitInsn(87);
                fio.visitLabel(_done);
            }
            MethodVisitor mv = cv.visitMethod(1, memberName, "()" + fieldDesc, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, memberName, fieldDesc);
            if (property.isPrimitive()) {
                mv.visitInsn(ConfigMappingGenerator.getReturnInstruction(property.asPrimitive()));
            } else {
                mv.visitInsn(176);
            }
            mv.visitEnd();
            mv.visitMaxs(0, 0);
        }
        for (ConfigMappingInterface superType : mapping.getSuperTypes()) {
            ConfigMappingGenerator.addProperties(cv, ctor, fio, visited, superType, className);
        }
    }

    private static boolean appendPropertyName(MethodVisitor ctor, ConfigMappingInterface.Property property, String memberName) {
        if (property.isParentPropertyName()) {
            return false;
        }
        Label _continue = new Label();
        ctor.visitVarInsn(25, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
        ctor.visitJumpInsn(153, _continue);
        ctor.visitVarInsn(25, 2);
        ctor.visitLdcInsn((Object)Character.valueOf('.'));
        ctor.visitInsn(146);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(C)L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(87);
        ctor.visitLabel(_continue);
        ctor.visitVarInsn(25, 2);
        if (property.hasPropertyName()) {
            ctor.visitLdcInsn((Object)property.getPropertyName());
        } else {
            ctor.visitLdcInsn((Object)ConfigMappingProvider.skewer(memberName));
        }
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(87);
        return true;
    }

    private static void restoreLength(MethodVisitor ctor) {
        ctor.visitVarInsn(25, 2);
        ctor.visitVarInsn(21, 3);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "setLength", "(I)V", false);
    }

    private static int getReturnInstruction(ConfigMappingInterface.PrimitiveProperty primitiveProperty) {
        if (primitiveProperty.getPrimitiveType() == Float.TYPE) {
            return 174;
        }
        if (primitiveProperty.getPrimitiveType() == Double.TYPE) {
            return 175;
        }
        if (primitiveProperty.getPrimitiveType() == Long.TYPE) {
            return 173;
        }
        return 172;
    }

    private static String getSignature(Field field) {
        String typeName = field.getGenericType().getTypeName();
        if (typeName.indexOf(60) != -1 && typeName.indexOf(62) != -1) {
            String signature = "()L" + typeName.replace(".", "/");
            signature = signature.replace("<", "<L");
            signature = signature.replace(">", ";>;");
            return signature;
        }
        return null;
    }

    private static boolean hasDefaultValue(Class<?> klass, Object value) {
        if (value == null) {
            return false;
        }
        if (klass.isPrimitive() && value instanceof Number && value.equals(0)) {
            return false;
        }
        if (klass.isPrimitive() && value instanceof Boolean && value.equals(Boolean.FALSE)) {
            return false;
        }
        return !klass.isPrimitive() || !(value instanceof Character) || !value.equals(0);
    }

    static final class Debugging {
        Debugging() {
        }

        static StackTraceElement getCaller() {
            return new Throwable().getStackTrace()[2];
        }

        static final class ClassVisitorImpl
        extends ClassVisitor {
            final String sourceFile = Debugging.getCaller().getFileName();

            ClassVisitorImpl(int api) {
                super(api);
            }

            ClassVisitorImpl(ClassWriter cw) {
                super(458752, (ClassVisitor)cw);
            }

            public void visitSource(String source, String debug) {
                super.visitSource(this.sourceFile, debug);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitorImpl(this.api, super.visitMethod(access, name, descriptor, signature, exceptions));
            }
        }

        static final class MethodVisitorImpl
        extends MethodVisitor {
            MethodVisitorImpl(int api) {
                super(api);
            }

            MethodVisitorImpl(int api, MethodVisitor methodVisitor) {
                super(api, methodVisitor);
            }

            public void visitInsn(int opcode) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInsn(opcode);
            }

            public void visitIntInsn(int opcode, int operand) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIntInsn(opcode, operand);
            }

            public void visitVarInsn(int opcode, int var) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitVarInsn(opcode, var);
            }

            public void visitTypeInsn(int opcode, String type) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTypeInsn(opcode, type);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }

            public void visitJumpInsn(int opcode, Label label) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitJumpInsn(opcode, label);
            }

            public void visitLdcInsn(Object value) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLdcInsn(value);
            }

            public void visitIincInsn(int var, int increment) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIincInsn(var, increment);
            }

            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTableSwitchInsn(min, max, dflt, labels);
            }

            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLookupSwitchInsn(dflt, keys, labels);
            }

            public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMultiANewArrayInsn(descriptor, numDimensions);
            }
        }
    }
}

