/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.business.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.swing.SwingWorker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.business.validation.ClientValidation;
import uy.ub.agesic.fd.business.validation.UtilsValidation;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.controllers.FirmarController;
import uy.ub.agesic.fd.dto.FirmaDTO;
import uy.ub.agesic.fd.dto.MensajesDTO;
import uy.ub.agesic.fd.dto.UbicacionFirma;
import uy.ub.agesic.fd.endpoints.ClienteRest;
import uy.ub.agesic.fd.enums.EstadosEnum;
import uy.ub.agesic.fd.enums.MetodoFirmaEnum;
import uy.ub.agesic.fd.enums.SistemaIniciadorEnum;
import uy.ub.agesic.fd.enums.TimeStampingEnum;
import uy.ub.agesic.fd.enums.TipoArchivoEnum;
import uy.ub.agesic.fd.exceptions.BusinessException;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.pdf.EmbedSignature;
import uy.ub.agesic.fd.pdf.PDFBoxSofisUtil;
import uy.ub.agesic.fd.store.SofisCertificate;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.SofisFile;
import uy.ub.agesic.fd.utils.StageUtil;
import uy.ub.agesic.fd.xml.XMLSignatureImpl;

public class SignBackgroundWorkerService
extends SwingWorker {
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    private StageHolder stageHolder = StageHolder.getInstance();
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    MessagesUtil msgUtil = new MessagesUtil(null);
    private final String errorSignedFiles = UtilsValidation.isSistemasExternos() ? this.msgUtil.getValue("MSG_ERROR_COMUNICACION_DOCUMENTOS") : this.msgUtil.getValue("MSG_ERROR_SIGNED_DOCUMENTOS");
    List<SofisFile> documentosSigned;
    List<SofisFile> documentosToSign;
    SofisCertificate cert;
    String pass;
    String userData;
    String idTransaccion;
    Throwable exception = null;
    boolean usuarioDocumentoFirmado;
    HashMap opciones = null;
    String typeProvider = "";
    MensajesDTO mensaje = new MensajesDTO();
    AlertasUtil alerta;

    public SignBackgroundWorkerService(SofisCertificate cert, String pass, List<SofisFile> documentosToSign, String userData, String idTransaccion, boolean usuarioDocumentoFirmado, HashMap opciones, String typeProvider, AlertasUtil alerta) {
        this.cert = cert;
        this.pass = pass;
        this.documentosToSign = documentosToSign;
        this.userData = userData;
        this.idTransaccion = idTransaccion;
        this.usuarioDocumentoFirmado = usuarioDocumentoFirmado;
        this.opciones = opciones;
        this.typeProvider = typeProvider;
        this.alerta = alerta;
    }

    protected Object doInBackground() {
        List<SofisFile> resu = null;
        try {
            Stage stage;
            this.documentosSigned = new ArrayList<SofisFile>();
            EmbedSignature pdfSignatureImpl = new EmbedSignature();
            Preferences prefs = Preferences.userRoot().node("PREFERENCES");
            boolean enviarEstadisticas = prefs.getBoolean("AUTORIZO_ENVIO_ESTADISTICAS", false);
            logger.log(Level.INFO, "Valor del envio de estadisticas: {0}", enviarEstadisticas);
            String extension = null;
            Boolean extensionXML = false;
            Boolean extensionPDF = false;
            Iterator<SofisFile> iterator = this.documentosToSign.iterator();
            while (iterator.hasNext()) {
                SofisFile fileToSign;
                SofisFile sf = fileToSign = iterator.next();
                if (fileToSign.getTipo().equalsIgnoreCase("pdf")) {
                    extensionPDF = true;
                    if (fileToSign.getUbicacionesFirma().isEmpty()) {
                        ArrayList ubicacionesFirmasDoc = new ArrayList();
                        ubicacionesFirmasDoc.add(new UbicacionFirma(PDFBoxSofisUtil.numeroPaginasDeDocumento(sf.getBytes()) - 1, 1, 1, 0, 0));
                        fileToSign.setUbicacionesFirma(ubicacionesFirmasDoc);
                    }
                    for (UbicacionFirma uf : fileToSign.getUbicacionesFirma()) {
                        sf = pdfSignatureImpl.signPDF(this.cert, this.pass, sf, this.typeProvider, uf, this.opciones);
                    }
                    if (!UtilsValidation.isSistemasExternos()) {
                        sf.setNombre(FilenameUtils.removeExtension((String)sf.getNombre()) + "-firmado." + FilenameUtils.getExtension((String)sf.getNombre()));
                    }
                    this.documentosSigned.add(sf);
                } else if (fileToSign.getTipo().equalsIgnoreCase("xml")) {
                    extensionXML = true;
                    XMLSignatureImpl xmlSignatureImpl = new XMLSignatureImpl();
                    sf = xmlSignatureImpl.signXML(this.cert, this.pass, fileToSign, this.userData, this.opciones);
                    if (!UtilsValidation.isSistemasExternos()) {
                        sf.setNombre(FilenameUtils.removeExtension((String)sf.getNombre()) + "-firmado." + FilenameUtils.getExtension((String)sf.getNombre()));
                    }
                    this.documentosSigned.add(sf);
                }
                if (enviarEstadisticas) {
                    logger.info("Seteo estadisticas para enviar");
                    FirmaDTO firma = new FirmaDTO();
                    firma.setFecha(LocalDateTime.now());
                    firma.setMetodoFirma(this.holder.getProceso().getMetodoFirma());
                    sf.setFirma(firma);
                    continue;
                }
                logger.info("No esta aceptado el envio de estadisticas");
            }
            if (UtilsValidation.isSistemasExternos()) {
                if (this.sendFilesSigned()) {
                    this.exception = null;
                    this.holder.setSofisFilesSigned(this.documentosSigned);
                    this.holder.getProceso().setCatidadFirmasAplicadas(this.holder.getProceso().getCatidadFirmasAplicadas() + 1);
                    resu = this.documentosSigned;
                } else {
                    stage = this.stageHolder.getStage();
                    stage.close();
                    this.exception = new Exception(this.errorSignedFiles);
                    resu = null;
                }
            } else {
                if (!Files.isDirectory(Paths.get(this.holder.getDirectorySignedFiles(), new String[0]), new LinkOption[0])) {
                    stage = this.stageHolder.getStage();
                    stage.close();
                    this.exception = new Exception(this.msgUtil.getValue("MSG_FAIL_SAVE_DIRECTORY"));
                    logger.log(Level.SEVERE, this.msgUtil.getValue("MSG_FAIL_SAVE_DIRECTORY"));
                    resu = null;
                }
                if (this.saveFilesSigned()) {
                    this.exception = null;
                    this.holder.setSofisFilesSigned(this.documentosSigned);
                    resu = this.documentosSigned;
                } else {
                    stage = this.stageHolder.getStage();
                    stage.close();
                    this.exception = new Exception(this.msgUtil.getValue("MSG_FAIL_SAVE_FILE"));
                    resu = null;
                }
                if (enviarEstadisticas) {
                    if (extensionPDF.booleanValue() && extensionXML.booleanValue()) {
                        extension = TipoArchivoEnum.PDF_XML.name();
                    } else if (extensionPDF.booleanValue()) {
                        extension = TipoArchivoEnum.PDF.name();
                    } else if (extensionXML.booleanValue()) {
                        extension = TipoArchivoEnum.XML.name();
                    }
                    this.enviarEstadisticas(prefs, extension);
                }
            }
            return resu;
        }
        catch (Exception e) {
            this.exception = e;
            logger.log(Level.SEVERE, SignBackgroundWorkerService.class.getName(), e);
            return null;
        }
    }

    private void enviarEstadisticas(Preferences prefs, String extension) {
        CompletableFuture.runAsync(() -> {
            try {
                String localHost = "localhost";
                int qtyDocumetosFirmados = this.documentosSigned != null ? this.documentosSigned.size() : 0;
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String fecha = LocalDateTime.now().format(formatter);
                String errores = "";
                int count = 1;
                String pendientes = prefs.get("ESTADISTICAS_PENDIENTES", "");
                logger.log(Level.INFO, "pendientes de enviar: {0}", pendientes);
                pendientes = (Object)((Object)SistemaIniciadorEnum.APLICATIVO) + "#" + localHost + "#" + fecha + "#" + this.holder.getProceso().getMetodoFirma().name() + "#" + TimeStampingEnum.LOCAL.name() + "#" + extension + "#" + qtyDocumetosFirmados + "#" + (qtyDocumetosFirmados > 1) + "," + pendientes;
                logger.log(Level.INFO, "Pendientes todos:: {0}", pendientes);
                StringTokenizer st = new StringTokenizer(pendientes, ",");
                while (st.hasMoreTokens()) {
                    try {
                        FirmaDTO dto = new FirmaDTO();
                        String elem = st.nextToken();
                        StringTokenizer tokensFirma = new StringTokenizer(elem, "#");
                        dto.setSistemaIniciador(SistemaIniciadorEnum.valueOf(tokensFirma.nextToken()));
                        dto.setOrigen(tokensFirma.nextToken());
                        LocalDateTime fechaLocalDateTime = LocalDateTime.parse(tokensFirma.nextToken(), formatter);
                        dto.setFecha(fechaLocalDateTime);
                        dto.setMetodoFirma(MetodoFirmaEnum.valueOf(tokensFirma.nextToken()));
                        dto.setTimeStamping(TimeStampingEnum.valueOf(tokensFirma.nextToken()));
                        dto.setTipoArchivo(TipoArchivoEnum.valueOf(tokensFirma.nextToken()));
                        dto.setCantidadDocumentos(Integer.valueOf(tokensFirma.nextToken()));
                        dto.setFirmaEnLote(Boolean.valueOf(tokensFirma.nextToken()));
                        ClienteRest restClient = new ClienteRest();
                        boolean enviada = restClient.sendSignStatistics(dto);
                        if (enviada) continue;
                        if (count < 1000) {
                            logger.log(Level.INFO, "Hubo errores al enviar las estadisticas, procedo a guardarla para enviarla despu\u00e9s");
                            errores = errores + "," + elem;
                            ++count;
                            continue;
                        }
                        logger.log(Level.INFO, "Llegu\u00e9 al m\u00e1ximo de firmas que voy a guardar");
                        break;
                    }
                    catch (Exception e) {
                        logger.log(Level.INFO, "Hubo un error de parseo de los datos de estadisticas, probablemente porquese genero con una version anterior, la descarto");
                    }
                }
                if (!StringUtils.isBlank((CharSequence)errores)) {
                    logger.log(Level.INFO, "Nueva lista de estadistica pendiente de enviar: {0}", errores);
                }
                prefs.put("ESTADISTICAS_PENDIENTES", errores);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error en env\u00edo de estadisticas::: ", ex);
            }
        });
    }

    private FirmaDTO prepararEstadisticaSistemaExternos() {
        try {
            FirmaDTO dto = new FirmaDTO();
            dto.setSistemaIniciador(SistemaIniciadorEnum.EXTERNOS);
            dto.setFecha(LocalDateTime.now());
            dto.setMetodoFirma(this.holder.getProceso().getMetodoFirma());
            dto.setTimeStamping(TimeStampingEnum.LOCAL);
            dto.setTipoArchivo(TipoArchivoEnum.PDF);
            dto.setEstado(EstadosEnum.FN.getNombre());
            dto.setIdentificador(this.holder.getProceso().getIdentificador());
            dto.setClaveSeguridad(this.holder.getProceso().getClaveSeguridad());
            return dto;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error en env\u00edo de estadisticas::: ", ex);
            return null;
        }
    }

    private boolean sendFilesSigned() {
        ClientValidation validation = new ClientValidation();
        try {
            for (SofisFile file : this.documentosSigned) {
                ClienteRest restClient = new ClienteRest();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getBytes());
                this.mensaje = restClient.sendFileSigned(inputStream, file.getIdentificadorFile());
                if (validation.validationRequestSendFilesSigned(this.mensaje)) continue;
                return false;
            }
        }
        catch (BusinessException e) {
            Logger.getLogger(SignBackgroundWorkerService.class.getName()).log(Level.SEVERE, null, e);
        }
        return true;
    }

    private boolean saveFilesSigned() throws IOException {
        try {
            for (SofisFile file : this.documentosSigned) {
                Files.write(Paths.get(this.holder.getDirectorySignedFiles() + file.getNombre(), new String[0]), file.getBytes(), new OpenOption[0]);
            }
            return true;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "SaveFilesSigned::: ", e);
            return false;
        }
    }

    private boolean finalizarProceso() {
        try {
            ClienteRest restClient = new ClienteRest();
            restClient.finalizar(this.prepararEstadisticaSistemaExternos());
        }
        catch (Exception e) {
            Logger.getLogger(FirmarController.class.getName()).log(Level.SEVERE, null, e);
        }
        return true;
    }

    @Override
    protected void done() {
        if (this.exception != null) {
            if (this.mensaje == null) {
                this.mensaje = new MensajesDTO();
                this.mensaje.setMensajeError(this.errorSignedFiles);
                if (this.msgUtil.getValue("MSG_CAROOT_EXPIRED").equalsIgnoreCase(this.exception.getMessage())) {
                    this.mensaje.setMensajeError(this.exception.getMessage());
                }
                this.mensaje.setMensaje("Excepcion");
                this.holder.setMensajes(this.mensaje);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Stage stage = SignBackgroundWorkerService.this.stageHolder.getStage();
                        stage.close();
                        SignBackgroundWorkerService.this.alerta.displayAlertError(SignBackgroundWorkerService.this.msgUtil.getValue("MSG_WS_INVOCATION_GENERAL"), SignBackgroundWorkerService.this.mensaje.getMensajeError());
                    }
                });
            } else {
                this.mensaje.setMensajeError(this.errorSignedFiles);
                if (this.msgUtil.getValue("MSG_CAROOT_EXPIRED").equalsIgnoreCase(this.exception.getMessage())) {
                    this.mensaje.setMensajeError(this.exception.getMessage());
                }
                this.mensaje.setMensaje("Error");
                this.holder.setMensajes(this.mensaje);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Stage stage = SignBackgroundWorkerService.this.stageHolder.getStage();
                        stage.close();
                        SignBackgroundWorkerService.this.alerta.displayAlertWarning(SignBackgroundWorkerService.this.mensaje.getMensajeError());
                    }
                });
            }
        } else {
            this.mensaje.setMensaje("ok");
            this.mensaje.setMensajeError(null);
            this.holder.setMensajes(this.mensaje);
            if (!StringUtils.isBlank((CharSequence)this.holder.getParemeterSistema()) && this.holder.getParemeterSistema().equalsIgnoreCase("EXTERNOS")) {
                if (this.holder.getProceso().getCantidadFirmantes() != null) {
                    if (this.holder.getProceso().getCantidadFirmantes() == 0 || this.holder.getProceso().getCantidadFirmantes() == 1) {
                        this.finalizarProceso();
                    } else if (this.holder.getProceso().getCantidadFirmantes() > 1 && this.holder.getProceso().getCatidadFirmasAplicadas() == this.holder.getProceso().getCantidadFirmantes()) {
                        this.finalizarProceso();
                    }
                } else {
                    this.finalizarProceso();
                }
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Stage stage = SignBackgroundWorkerService.this.stageHolder.getStage();
                        stage.close();
                        StageUtil stageUtil = new StageUtil();
                        stageUtil.open(SignBackgroundWorkerService.this.stageHolder.getEvent(), "Confirmacion");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SignBackgroundWorkerService.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
    }
}

