/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.config;

import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import sun.misc.BASE64Decoder;
import uy.ub.agesic.fd.application.AppViewer;

public class ConfigurationUtil {
    private ResourceBundle bundle = null;
    private HashMap<String, String> options = null;
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    private Preferences prefs = Preferences.userRoot().node("PREFERENCES");

    public ConfigurationUtil(HashMap<String, String> options) {
        this.options = options;
        this.bundle = ResourceBundle.getBundle("configuration");
    }

    public String getValue(String key) {
        try {
            if (this.options == null || !this.options.containsKey(key)) {
                return this.bundle.getString(key);
            }
            return this.options.get(key);
        }
        catch (Exception e) {
            return "??" + key + "??";
        }
    }

    public String getDriverPath(String token, String key) {
        String paths = "";
        try {
            paths = this.options == null || !this.options.containsKey(key) ? this.bundle.getString(key) : this.options.get(key);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "KEY NO ENCONTRADA: ??{0}??", key);
        }
        if (this.getValue("DISPOSITIVOS_CEDULA").contains(token)) {
            if (StringUtils.isNotBlank((CharSequence)this.prefs.get("PATH_DRIVER_CEDULA", ""))) {
                paths = this.prefs.get("PATH_DRIVER_CEDULA", "") + "; " + paths;
            }
        } else if (this.getValue("DISPOSITIVOS_ABITAB").contains(token)) {
            if (StringUtils.isNotBlank((CharSequence)this.prefs.get("PATH_DRIVER_TOKEN_ABITAB", ""))) {
                paths = this.prefs.get("PATH_DRIVER_TOKEN_ABITAB", "") + "; " + paths;
            }
        } else if (this.getValue("DISPOSITIVOS_CORREO").contains(token) && StringUtils.isNotBlank((CharSequence)this.prefs.get("PATH_DRIVER_TOKEN_CORREO", ""))) {
            paths = this.prefs.get("PATH_DRIVER_TOKEN_CORREO", "") + "; " + paths;
        }
        logger.info(key + " --> " + paths);
        return paths;
    }

    public boolean contains(String key) {
        if (this.options == null || !this.options.containsKey(key)) {
            return this.bundle.containsKey(key);
        }
        return this.options.containsKey(key);
    }

    public boolean getBooleanValue(String key) {
        String value = null;
        value = this.options == null || !this.options.containsKey(key) ? this.bundle.getString(key) : this.options.get(key);
        if (value != null && !value.equalsIgnoreCase("")) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception w) {
                return false;
            }
        }
        return false;
    }

    public Integer getIntValue(String key) {
        try {
            String value = null;
            value = this.options == null || !this.options.containsKey(key) ? this.bundle.getString(key) : this.options.get(key);
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Image getAWTImageValue(String key) {
        String value = null;
        if (this.options == null || !this.options.containsKey(key)) {
            value = this.bundle.getString(key);
            try {
                URL url = null;
                url = !value.startsWith("/") ? ConfigurationUtil.class.getResource("/" + value) : ConfigurationUtil.class.getResource(value);
                ImageIcon stampImg = new ImageIcon(url);
                return stampImg.getImage();
            }
            catch (Throwable w) {
                logger.log(Level.SEVERE, "Throwable ", w);
                return null;
            }
        }
        value = this.options.get(key);
        if (value != null && !value.equalsIgnoreCase("")) {
            try {
                BASE64Decoder decoder = new BASE64Decoder();
                byte[] imageByte = decoder.decodeBuffer(value);
                ImageIcon stampImg = new ImageIcon(imageByte);
                return stampImg.getImage();
            }
            catch (Exception q) {
                logger.log(Level.SEVERE, "Exception ", q);
            }
        }
        return null;
    }

    public InputStream getInputStream(String key) {
        String value = null;
        value = this.options == null || !this.options.containsKey(key) ? this.bundle.getString(key) : this.options.get(key);
        if (value != null && !value.equalsIgnoreCase("")) {
            try {
                URL url = null;
                url = !value.startsWith("/") ? ConfigurationUtil.class.getResource("/" + value) : ConfigurationUtil.class.getResource(value);
                return url.openStream();
            }
            catch (Throwable w) {
                logger.log(Level.SEVERE, "Throwable ", w);
                return null;
            }
        }
        return null;
    }

    public Set<String> keySet() {
        if (this.options == null) {
            return this.bundle.keySet();
        }
        Set<String> setToReturn = this.bundle.keySet();
        setToReturn.addAll(this.options.keySet());
        return setToReturn;
    }
}

