/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.config;

import java.awt.Image;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import sun.misc.BASE64Decoder;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.ConfigurationUtil;

public class MessagesUtil {
    static ResourceBundle bundle = null;
    static Locale locale = null;
    private HashMap<String, String> options = null;
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());

    public MessagesUtil(HashMap<String, String> options) {
        this.options = options;
        bundle = ResourceBundle.getBundle("messages");
    }

    public void setLocale(String localeStr) {
        locale = localeStr != null && !localeStr.equalsIgnoreCase("") ? new Locale(localeStr) : Locale.ROOT;
        bundle = ResourceBundle.getBundle("messages", locale);
    }

    public boolean containsKey(String key) {
        try {
            if (this.options == null || !this.options.containsKey(key)) {
                return bundle.containsKey(key);
            }
            return this.options.containsKey(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getValue(String key) {
        try {
            if (this.options == null || !this.options.containsKey(key)) {
                return bundle.getString(key);
            }
            return this.options.get(key);
        }
        catch (Exception e) {
            return "??" + key + "??";
        }
    }

    public boolean getBooleanValue(String key) {
        String value = this.options == null || !this.options.containsKey(key) ? bundle.getString(key) : this.options.get(key);
        if (value != null && !value.equalsIgnoreCase("")) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception w) {
                return false;
            }
        }
        return false;
    }

    public Integer getIntValue(String key) {
        try {
            String value = this.options == null || !this.options.containsKey(key) ? bundle.getString(key) : this.options.get(key);
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Float getFloatValue(String key) {
        try {
            String value = this.options == null || !this.options.containsKey(key) ? bundle.getString(key) : this.options.get(key);
            return Float.valueOf(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Image getAWTImageValue(String key) {
        String value = null;
        if (this.options == null || !this.options.containsKey(key)) {
            value = bundle.getString(key);
            if (value != null && value.trim().length() > 0) {
                try {
                    URL url = null;
                    url = !value.startsWith("/") ? ConfigurationUtil.class.getResource("/" + value) : ConfigurationUtil.class.getResource(value);
                    ImageIcon stampImg = new ImageIcon(url);
                    return stampImg.getImage();
                }
                catch (Throwable w) {
                    return null;
                }
            }
            return null;
        }
        value = this.options.get(key);
        if (value != null && !value.equalsIgnoreCase("")) {
            try {
                BASE64Decoder decoder = new BASE64Decoder();
                byte[] imageByte = decoder.decodeBuffer(value);
                ImageIcon stampImg = new ImageIcon(imageByte);
                return stampImg.getImage();
            }
            catch (Exception q) {
                logger.log(Level.SEVERE, "Exception ", q);
            }
        }
        return null;
    }

    public InputStream getInputStream(String key) {
        String value = null;
        value = this.options == null || !this.options.containsKey(key) ? bundle.getString(key) : this.options.get(key);
        if (value != null && !value.equalsIgnoreCase("")) {
            try {
                URL url = null;
                url = !value.startsWith("/") ? ConfigurationUtil.class.getResource("/" + value) : ConfigurationUtil.class.getResource(value);
                return url.openStream();
            }
            catch (Throwable w) {
                logger.log(Level.SEVERE, "Throwable ", w);
                return null;
            }
        }
        return null;
    }

    public Set<String> keySet() {
        if (this.options == null) {
            return bundle.keySet();
        }
        Set<String> setToReturn = bundle.keySet();
        setToReturn.addAll(this.options.keySet());
        return setToReturn;
    }
}

