/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.controllers;

import eu.bitwalker.useragentutils.UserAgent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.AppletParams;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.controllers.DisplayFilesController;
import uy.ub.agesic.fd.dto.ProcesoDTO;
import uy.ub.agesic.fd.enums.MetodoFirmaEnum;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.store.pkcs11.VerifyToken;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.OSValidator;
import uy.ub.agesic.fd.utils.StageUtil;

public class SeleccionDispositivoFirmaController
implements Initializable {
    @FXML
    private AnchorPane main;
    @FXML
    private ToggleGroup tgSelected1;
    @FXML
    private Button btnAceptar;
    @FXML
    private RadioButton rbTokenAbitab;
    @FXML
    private RadioButton rbTokenCorreo;
    @FXML
    private RadioButton rbArchivoDisco;
    @FXML
    private Button btnActualizar;
    @FXML
    private RadioButton rbCedulaIdentidad;
    @FXML
    private Button btnCancelar;
    @FXML
    private CheckBox cbxRecordar;
    @FXML
    private Text lblEstadoCedula;
    @FXML
    private Text lblEstadoCorreo;
    @FXML
    private Text lblTitulo;
    @FXML
    private Text lblSubTitulo;
    @FXML
    private Text lblEstadoAbitab;
    @FXML
    private Hyperlink linkDesSoftwareCedula;
    @FXML
    private Hyperlink linkDesSoftwareAbitab;
    @FXML
    private Hyperlink linkDesSoftwareCorreo;
    @FXML
    private ImageView logoAgesic;
    @FXML
    private Button btnProxy;
    @FXML
    private Button btnArchivo;
    AlertasUtil alerta = new AlertasUtil();
    MessagesUtil msgUtil = new MessagesUtil(null);
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    private StageHolder stageHolder = StageHolder.getInstance();
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    ConfigurationUtil cfgUtil = new ConfigurationUtil(null);
    private HashMap<String, String> opciones = null;
    private static final HashMap<String, String> params = new HashMap();

    public void initialize(URL url, ResourceBundle rb) {
        this.cbxRecordar.setVisible(false);
        Image imageLogo = new Image(this.getClass().getResourceAsStream("/images/agesic-color.png"));
        this.logoAgesic.setImage(imageLogo);
        this.rbArchivoDisco.setDisable(true);
        this.rbArchivoDisco.setVisible(false);
        String locale = this.cfgUtil.getValue("LOCALE");
        this.msgUtil.setLocale(locale);
        this.initOpciones();
        this.initUserAgent();
        this.determinarDispositivosDisponibles();
        this.initLinksAndButtons();
        if (this.holder.getProceso() != null && this.holder.getProceso().getMetodoFirma() != null) {
            switch (this.holder.getProceso().getMetodoFirma()) {
                case CEDULA: {
                    this.rbCedulaIdentidad.setSelected(true);
                    break;
                }
                case TOKEN_ABITAB: {
                    this.rbTokenAbitab.setSelected(true);
                    break;
                }
                case TOKEN_CORREO: {
                    this.rbTokenCorreo.setSelected(true);
                    break;
                }
                case P12: {
                    this.rbArchivoDisco.setSelected(true);
                    break;
                }
            }
        }
        if (AppletParams.ACTIVAR_P12.booleanValue()) {
            this.rbArchivoDisco.setSelected(true);
        }
    }

    @FXML
    private void cancel(ActionEvent event) throws IOException {
        StageUtil stage = new StageUtil();
        stage.close((Event)event);
        Platform.exit();
        System.exit(0);
    }

    @FXML
    private void accept(ActionEvent event) {
        try {
            if (!(this.rbCedulaIdentidad.isSelected() || this.rbTokenAbitab.isSelected() || this.rbTokenCorreo.isSelected() || this.rbArchivoDisco.isSelected() || AppletParams.ACTIVAR_P12.booleanValue())) {
                this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_SELECT_TIPO_DISPOSITIVO"));
                return;
            }
            StageUtil stage = new StageUtil();
            ProcesoDTO proceso = new ProcesoDTO();
            String jxml = "DragAndDrop";
            if (this.rbCedulaIdentidad.isSelected()) {
                if (!this.verificarQueTengaTokenConetadoSeleccionado(MetodoFirmaEnum.CEDULA).booleanValue()) {
                    this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_LECTOR_O_DRIVER_NO_DISPONIBLE"));
                    return;
                }
                stage.close((Event)event);
                proceso.setMetodoFirma(MetodoFirmaEnum.CEDULA);
                this.holder.setProceso(proceso);
                stage.open((Event)event, jxml);
                return;
            }
            if (this.rbTokenAbitab.isSelected()) {
                if (!this.verificarQueTengaTokenConetadoSeleccionado(MetodoFirmaEnum.TOKEN_ABITAB).booleanValue()) {
                    this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_LECTOR_O_DRIVER_NO_DISPONIBLE"));
                    return;
                }
                stage.close((Event)event);
                proceso.setMetodoFirma(MetodoFirmaEnum.TOKEN_ABITAB);
                this.holder.setProceso(proceso);
                stage.open((Event)event, jxml);
                return;
            }
            if (this.rbTokenCorreo.isSelected()) {
                if (!this.verificarQueTengaTokenConetadoSeleccionado(MetodoFirmaEnum.TOKEN_CORREO).booleanValue()) {
                    this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_LECTOR_O_DRIVER_NO_DISPONIBLE"));
                    return;
                }
                stage.close((Event)event);
                proceso.setMetodoFirma(MetodoFirmaEnum.TOKEN_CORREO);
                this.holder.setProceso(proceso);
                stage.open((Event)event, jxml);
                return;
            }
            if (this.rbArchivoDisco.isSelected()) {
                stage.close((Event)event);
                proceso.setMetodoFirma(MetodoFirmaEnum.P12);
                this.holder.setProceso(proceso);
                stage.open((Event)event, jxml);
                return;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
        }
    }

    @FXML
    private void pressAccept(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            try {
                if (!(this.rbCedulaIdentidad.isSelected() || this.rbTokenAbitab.isSelected() || this.rbTokenCorreo.isSelected() || this.rbArchivoDisco.isSelected() || AppletParams.ACTIVAR_P12.booleanValue())) {
                    this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_SELECT_TIPO_DISPOSITIVO"));
                    return;
                }
                Node nodeClose = (Node)event.getSource();
                Stage stg = (Stage)nodeClose.getScene().getWindow();
                ProcesoDTO proceso = new ProcesoDTO();
                String jxml = "DragAndDrop";
                StageUtil stage = new StageUtil();
                if (this.rbCedulaIdentidad.isSelected()) {
                    if (!this.verificarQueTengaTokenConetadoSeleccionado(MetodoFirmaEnum.CEDULA).booleanValue()) {
                        this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_LECTOR_O_DRIVER_NO_DISPONIBLE") + "cedula");
                        return;
                    }
                    stage.close((Event)event);
                    proceso.setMetodoFirma(MetodoFirmaEnum.CEDULA);
                    this.holder.setProceso(proceso);
                    stage.open((Event)event, jxml);
                    return;
                }
                if (this.rbTokenAbitab.isSelected()) {
                    if (!this.verificarQueTengaTokenConetadoSeleccionado(MetodoFirmaEnum.TOKEN_ABITAB).booleanValue()) {
                        this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_LECTOR_O_DRIVER_NO_DISPONIBLE"));
                        return;
                    }
                    stage.close((Event)event);
                    proceso.setMetodoFirma(MetodoFirmaEnum.TOKEN_ABITAB);
                    this.holder.setProceso(proceso);
                    stage.open((Event)event, jxml);
                    return;
                }
                if (this.rbTokenCorreo.isSelected()) {
                    if (!this.verificarQueTengaTokenConetadoSeleccionado(MetodoFirmaEnum.TOKEN_CORREO).booleanValue()) {
                        this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_LECTOR_O_DRIVER_NO_DISPONIBLE"));
                        return;
                    }
                    stage.close((Event)event);
                    proceso.setMetodoFirma(MetodoFirmaEnum.TOKEN_CORREO);
                    this.holder.setProceso(proceso);
                    stage.open((Event)event, jxml);
                    return;
                }
                if (this.rbArchivoDisco.isSelected()) {
                    proceso.setMetodoFirma(MetodoFirmaEnum.P12);
                    this.holder.setProceso(proceso);
                    stage.open((Event)event, jxml);
                    return;
                }
            }
            catch (Exception e) {
                System.out.println(e);
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
            }
        }
    }

    private void initUserAgent() {
        this.holder.setUserAgent(this.getBrowserIfo());
        this.holder.setUserHomePath(System.getProperty("user.home"));
    }

    private void initOpciones() {
        this.opciones = new HashMap();
        if (this.cfgUtil == null) {
            this.cfgUtil = new ConfigurationUtil(null);
        }
        for (String key : this.cfgUtil.keySet()) {
            try {
                String keyValue = this.getParams(key);
                if (keyValue == null) continue;
                this.opciones.put(key, keyValue);
            }
            catch (Exception w) {
                Logger.getLogger(AppViewer.class.getName()).log(Level.SEVERE, key, w);
            }
        }
        this.cfgUtil = new ConfigurationUtil(this.opciones);
        if (this.msgUtil == null) {
            this.msgUtil = new MessagesUtil(null);
        }
        String locale = this.cfgUtil.getValue("LOCALE");
        this.msgUtil.setLocale(locale);
        for (String key : this.msgUtil.keySet()) {
            try {
                String keyValue = this.getParams(key);
                if (keyValue == null) continue;
                this.opciones.put(key, keyValue);
            }
            catch (Exception w) {
                Logger.getLogger(AppViewer.class.getName()).log(Level.SEVERE, key, w);
            }
        }
        this.msgUtil = new MessagesUtil(this.opciones);
        this.holder.setCfgUtil(this.cfgUtil);
        this.holder.setOpciones(this.opciones);
        this.holder.setMsgUtil(this.msgUtil);
    }

    public UserAgent getBrowserIfo() {
        try {
            UserAgent uAgent = new UserAgent("User-agent header sent: Mozilla/5.0 (" + OSValidator.getOSName() + " " + OSValidator.getOSVersion() + "; WOW64; rv:42.0) Gecko/20100101 Firefox/42.0");
            return uAgent;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getParams(String key) {
        return params.get(key);
    }

    private int determinarDispositivosDisponibles() {
        int cantDispositivos = 0;
        String devNotAvailable = "DEV-NOT-AVAILABLE";
        String devDisconected = "DEV-DISCONECTED";
        String devConected = "DEV-CONNECTED";
        String imagesPath = "/images/";
        String extension = ".png";
        VerifyToken verify = new VerifyToken();
        String[] dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_CEDULA").split(";");
        int[] tokens = verify.verificarTokens(dispositivos);
        int tokensInstalados = tokens[0];
        int tokensConectados = tokens[1];
        String estado = tokensInstalados < 1 ? devNotAvailable : (tokensConectados < 1 ? devDisconected : devConected);
        this.lblEstadoCedula.setText(this.msgUtil.getValue(estado));
        Image imageCedula = new Image(this.getClass().getResourceAsStream(imagesPath + estado + extension));
        this.linkDesSoftwareCedula.setVisible(estado.equals(devNotAvailable));
        cantDispositivos += tokensConectados;
        dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_ABITAB").split(";");
        tokens = verify.verificarTokens(dispositivos);
        tokensInstalados = tokens[0];
        tokensConectados = tokens[1];
        estado = tokensInstalados < 1 ? devNotAvailable : (tokensConectados < 1 ? devDisconected : devConected);
        this.lblEstadoAbitab.setText(this.msgUtil.getValue(estado));
        Image imageAbitab = new Image(this.getClass().getResourceAsStream(imagesPath + estado + extension));
        this.linkDesSoftwareAbitab.setVisible(estado.equals(devNotAvailable));
        cantDispositivos += tokensConectados;
        dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_CORREO").split(";");
        tokens = verify.verificarTokens(dispositivos);
        tokensInstalados = tokens[0];
        tokensConectados = tokens[1];
        estado = tokensInstalados < 1 ? devNotAvailable : (tokensConectados < 1 ? devDisconected : devConected);
        this.lblEstadoCorreo.setText(this.msgUtil.getValue(estado));
        Image imageCorreo = new Image(this.getClass().getResourceAsStream(imagesPath + estado + extension));
        this.linkDesSoftwareCorreo.setVisible(estado.equals(devNotAvailable));
        return cantDispositivos += tokensConectados;
    }

    private Boolean verificarQueTengaTokenConetadoSeleccionado(MetodoFirmaEnum mf) {
        int cantDispositivos = 0;
        VerifyToken verify = new VerifyToken();
        if (mf.equals((Object)MetodoFirmaEnum.CEDULA)) {
            String[] dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_CEDULA").split(";");
            int[] tokens = verify.verificarTokens(dispositivos);
            int tokensConectados = tokens[1];
            return (cantDispositivos += tokensConectados) > 0;
        }
        if (mf.equals((Object)MetodoFirmaEnum.TOKEN_ABITAB)) {
            String[] dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_ABITAB").split(";");
            int[] tokens = verify.verificarTokens(dispositivos);
            int tokensConectados = tokens[1];
            return (cantDispositivos += tokensConectados) > 0;
        }
        if (mf.equals((Object)MetodoFirmaEnum.TOKEN_CORREO)) {
            String[] dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_CORREO").split(";");
            int[] tokens = verify.verificarTokens(dispositivos);
            int tokensConectados = tokens[1];
            return (cantDispositivos += tokensConectados) > 0;
        }
        if (AppletParams.ACTIVAR_P12.booleanValue()) {
            return true;
        }
        return false;
    }

    @FXML
    private void actualizar(ActionEvent event) {
        this.determinarDispositivosDisponibles();
    }

    @FXML
    private void descargarSoftwareCedula(ActionEvent event) {
        AppViewer app = new AppViewer();
        app.openBrowser("https://www.gub.uy/agencia-gobierno-electronico-sociedad-informacion-conocimiento/firma-digital/drivers-para-usar-cedula-digital");
    }

    @FXML
    private void descargarSoftwareAbitab(ActionEvent event) {
        AppViewer app = new AppViewer();
        if (OSValidator.getOperatingSystem().equalsIgnoreCase("WINDOWS")) {
            app.openBrowser("https://iddigital.com.uy/es/ayuda-y-soporte/software/");
        } else {
            app.openBrowser("https://www.iddigital.com.uy/media/filer_public/c4/fe/c4fe17f0-233c-4522-8ced-f5cc66723a6c/tokeniddigitaladmin_v4500.zip");
        }
    }

    @FXML
    private void descargarSoftwareCorreo(ActionEvent event) {
        AppViewer app = new AppViewer();
        app.openBrowser("https://www.iddigital.com.uy/media/filer_public/c4/fe/c4fe17f0-233c-4522-8ced-f5cc66723a6c/tokeniddigitaladmin_v4500.zip");
    }

    @FXML
    private void proxy(ActionEvent event) {
        try {
            StageUtil stage = new StageUtil();
            ProcesoDTO proceso = new ProcesoDTO();
            String jxml = "Configuration";
            this.holder.setProceso(proceso);
            stage.open((Event)event, jxml);
            return;
        }
        catch (Exception e) {
            System.out.println(e);
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
            return;
        }
    }

    @FXML
    private void pressCancel(KeyEvent ke) {
        if (ke.getCode() == KeyCode.ENTER) {
            Node nodeClose = (Node)ke.getSource();
            Stage stage = (Stage)nodeClose.getScene().getWindow();
            stage.close();
            Platform.exit();
            System.exit(0);
        }
    }

    private void initLinksAndButtons() {
        this.linkDesSoftwareCedula.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.descargarSoftwareCedula(new ActionEvent());
            }
        });
        this.linkDesSoftwareCedula.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.descargarSoftwareAbitab(new ActionEvent());
            }
        });
        this.linkDesSoftwareCedula.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.descargarSoftwareCorreo(new ActionEvent());
            }
        });
        this.btnProxy.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.proxy(new ActionEvent());
            }
        });
        this.btnActualizar.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.actualizar(new ActionEvent());
            }
        });
        this.rbCedulaIdentidad.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.rbCedulaIdentidad.isSelected()) {
                    this.rbCedulaIdentidad.setSelected(false);
                } else {
                    this.rbCedulaIdentidad.setSelected(true);
                    this.rbTokenAbitab.setSelected(false);
                    this.rbTokenCorreo.setSelected(false);
                }
            }
        });
        this.rbTokenAbitab.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.rbTokenAbitab.isSelected()) {
                    this.rbTokenAbitab.setSelected(false);
                } else {
                    this.rbTokenAbitab.setSelected(true);
                    this.rbCedulaIdentidad.setSelected(false);
                    this.rbTokenCorreo.setSelected(false);
                }
            }
        });
        this.rbTokenCorreo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.rbTokenCorreo.isSelected()) {
                    this.rbTokenCorreo.setSelected(false);
                } else {
                    this.rbTokenCorreo.setSelected(true);
                    this.rbCedulaIdentidad.setSelected(false);
                    this.rbTokenAbitab.setSelected(false);
                }
            }
        });
    }

    @FXML
    private void cargarArchivo(ActionEvent event) {
        logger.info("cargarArchivo");
        FileChooser chooser = new FileChooser();
        chooser.setTitle(this.msgUtil.getValue("MSG_SELECT_FILE_PROCESS"));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(this.msgUtil.getValue("FILE_SIGN_EXTENSION"), new String[]{"*.firmagubuy"})});
        StageUtil stage = new StageUtil();
        File file = chooser.showOpenDialog((Window)stage.getStage());
        if (file != null) {
            try {
                this.loadFile(file.getAbsolutePath());
                this.stageHolder.setResizable(true);
                DisplayFilesController dispay = new DisplayFilesController();
                dispay.initialize(this.stageHolder.getStage());
                this.stageHolder.setResizable(false);
            }
            catch (IOException ex) {
                Logger.getLogger(SeleccionDispositivoFirmaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadFile(String path) throws IOException {
        BufferedReader bufferedReader = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            File file = null;
            String readLine = "";
            Integer lineNumber = 0;
            file = new File(path);
            bufferedReader = new BufferedReader(new FileReader(file));
            block18: while ((readLine = bufferedReader.readLine()) != null) {
                lines.add(readLine);
                Integer n = lineNumber;
                Integer n2 = lineNumber = Integer.valueOf(lineNumber + 1);
                switch (lineNumber) {
                    case 1: {
                        this.holder.setParemeterIdentifier(readLine.trim());
                        continue block18;
                    }
                    case 2: {
                        this.holder.setParemeterPassword(readLine.trim());
                        continue block18;
                    }
                    case 3: {
                        this.holder.setParemeterMetodo(MetodoFirmaEnum.valueOf(readLine.trim()));
                        continue block18;
                    }
                    case 4: {
                        this.holder.setParemeterUrl(readLine.trim());
                        continue block18;
                    }
                    case 5: {
                        this.holder.setParemeterSistema(readLine.trim());
                        continue block18;
                    }
                }
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "IOException ", ioe);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "IOException ", e);
                }
            }
        }
        return lines;
    }
}

