/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.controllers;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.AppletParams;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.enums.MetodoFirmaEnum;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.store.pkcs11.VerifyToken;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.StageUtil;

public class SeleccionarDispositivoController
implements Initializable {
    @FXML
    private Button btnNext;
    @FXML
    private RadioButton rbCedulaIdentidad;
    @FXML
    private RadioButton rbTokenAbitab;
    @FXML
    private RadioButton rbTokenCorreo;
    @FXML
    private Button btnCancelar;
    @FXML
    private RadioButton rbArchivoDisco;
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    MessagesUtil msgUtil = new MessagesUtil(null);
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    @FXML
    private Label cedulaLbIcon;
    @FXML
    private Label abitabLbIcon;
    @FXML
    private Label correoLbIcon;
    @FXML
    private Button btnActualizar;
    @FXML
    private ToggleGroup tgSelected1;

    public void initialize(URL url, ResourceBundle rb) {
        if (!AppletParams.ACTIVAR_P12.booleanValue()) {
            this.rbArchivoDisco.setDisable(true);
            this.rbArchivoDisco.setVisible(false);
        }
        this.determinarDispositivosDisponibles();
        this.initButtons();
    }

    @FXML
    private void handleBtnNext(ActionEvent event) throws IOException {
        AlertasUtil alerta = new AlertasUtil();
        String firmar = "Firmar";
        try {
            if (!(this.rbCedulaIdentidad.isSelected() || this.rbTokenAbitab.isSelected() || this.rbTokenCorreo.isSelected() || this.rbArchivoDisco.isSelected())) {
                alerta.displayAlertWarning(this.msgUtil.getValue("MSG_SELECT_TIPO_DISPOSITIVO"));
                return;
            }
            StageUtil stage = new StageUtil();
            stage.close((Event)event);
            if (this.rbCedulaIdentidad.isSelected()) {
                this.holder.getProceso().setMetodoFirma(MetodoFirmaEnum.CEDULA);
                stage.openDialog((Event)event, "Firmar");
                return;
            }
            if (this.rbTokenAbitab.isSelected()) {
                this.holder.getProceso().setMetodoFirma(MetodoFirmaEnum.TOKEN_ABITAB);
                stage.openDialog((Event)event, "Firmar");
                return;
            }
            if (this.rbTokenCorreo.isSelected()) {
                this.holder.getProceso().setMetodoFirma(MetodoFirmaEnum.TOKEN_CORREO);
                stage.openDialog((Event)event, "Firmar");
                return;
            }
            if (this.rbArchivoDisco.isSelected()) {
                if (AppletParams.ACTIVAR_P12.booleanValue()) {
                    this.holder.getProceso().setMetodoFirma(MetodoFirmaEnum.P12);
                    stage.openDialog((Event)event, "Firmar");
                }
                return;
            }
        }
        catch (Exception e) {
            alerta.displayAlertError(this.msgUtil.getValue("MSG_APLICATION"), this.msgUtil.getValue("MSG_APLICATION_DES"));
        }
    }

    @FXML
    private void pressContinue(KeyEvent event) throws IOException {
        if (event.getCode() == KeyCode.ENTER) {
            AlertasUtil alerta = new AlertasUtil();
            String firmar = "Firmar";
            try {
                if (!(this.rbCedulaIdentidad.isSelected() || this.rbTokenAbitab.isSelected() || this.rbTokenCorreo.isSelected() || this.rbArchivoDisco.isSelected())) {
                    alerta.displayAlertWarning(this.msgUtil.getValue("MSG_SELECT_TIPO_DISPOSITIVO"));
                    return;
                }
                StageUtil stage = new StageUtil();
                Node nodeClose = (Node)event.getSource();
                Stage stageToClose = (Stage)nodeClose.getScene().getWindow();
                stageToClose.close();
                if (this.rbCedulaIdentidad.isSelected()) {
                    this.holder.getProceso().setMetodoFirma(MetodoFirmaEnum.CEDULA);
                    stage.openDialog((Event)event, "Firmar");
                    return;
                }
                if (this.rbTokenAbitab.isSelected()) {
                    this.holder.getProceso().setMetodoFirma(MetodoFirmaEnum.TOKEN_ABITAB);
                    stage.openDialog((Event)event, "Firmar");
                    return;
                }
                if (this.rbTokenCorreo.isSelected()) {
                    this.holder.getProceso().setMetodoFirma(MetodoFirmaEnum.TOKEN_CORREO);
                    stage.openDialog((Event)event, "Firmar");
                    return;
                }
                if (this.rbArchivoDisco.isSelected()) {
                    if (AppletParams.ACTIVAR_P12.booleanValue()) {
                        this.holder.getProceso().setMetodoFirma(MetodoFirmaEnum.P12);
                        stage.openDialog((Event)event, "Firmar");
                    }
                    return;
                }
            }
            catch (Exception e) {
                alerta.displayAlertError(this.msgUtil.getValue("MSG_APLICATION"), this.msgUtil.getValue("MSG_APLICATION_DES"));
            }
        }
    }

    @FXML
    private void actualizarDispositivos(ActionEvent event) throws IOException {
        try {
            this.determinarDispositivosDisponibles();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "No se pudir\u00f3n actualizar los dispositivos ", e);
        }
    }

    @FXML
    private void pressUpdate(KeyEvent event) throws IOException {
        if (event.getCode() == KeyCode.ENTER) {
            try {
                this.determinarDispositivosDisponibles();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "No se pudir\u00f3n actualizar los dispositivos ", e);
            }
        }
    }

    private int determinarDispositivosDisponibles() {
        int cantDispositivos = 0;
        String devNotAvailable = "DEV-NOT-AVAILABLE";
        String devDisconected = "DEV-DISCONECTED";
        String devConected = "DEV-CONNECTED";
        String imagesPath = "/images/";
        String extension = ".png";
        VerifyToken verify = new VerifyToken();
        String[] dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_CEDULA").split(";");
        int[] tokens = verify.verificarTokens(dispositivos);
        int tokensInstalados = tokens[0];
        int tokensConectados = tokens[1];
        String icono = tokensInstalados < 1 ? devNotAvailable : (tokensConectados < 1 ? devDisconected : devConected);
        Image imageCedula = new Image(this.getClass().getResourceAsStream(imagesPath + icono + extension));
        this.cedulaLbIcon.setGraphic((Node)new ImageView(imageCedula));
        cantDispositivos += tokensConectados;
        dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_ABITAB").split(";");
        tokens = verify.verificarTokens(dispositivos);
        tokensInstalados = tokens[0];
        tokensConectados = tokens[1];
        icono = tokensInstalados < 1 ? devNotAvailable : (tokensConectados < 1 ? devDisconected : devConected);
        Image imageAbitab = new Image(this.getClass().getResourceAsStream(imagesPath + icono + extension));
        this.abitabLbIcon.setGraphic((Node)new ImageView(imageAbitab));
        cantDispositivos += tokensConectados;
        dispositivos = this.holder.getCfgUtil().getValue("DISPOSITIVOS_CORREO").split(";");
        tokens = verify.verificarTokens(dispositivos);
        tokensInstalados = tokens[0];
        tokensConectados = tokens[1];
        icono = tokensInstalados < 1 ? devNotAvailable : (tokensConectados < 1 ? devDisconected : devConected);
        Image imageCorreo = new Image(this.getClass().getResourceAsStream(imagesPath + icono + extension));
        this.correoLbIcon.setGraphic((Node)new ImageView(imageCorreo));
        return cantDispositivos += tokensConectados;
    }

    @FXML
    private void cancelar(ActionEvent event) throws IOException {
        StageUtil stage = new StageUtil();
        stage.close((Event)event);
    }

    @FXML
    private void pressCancel(KeyEvent ke) {
        if (ke.getCode() == KeyCode.ENTER) {
            Node nodeClose = (Node)ke.getSource();
            Stage stage = (Stage)nodeClose.getScene().getWindow();
            stage.close();
        }
    }

    private void initButtons() {
        this.rbCedulaIdentidad.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.rbCedulaIdentidad.isSelected()) {
                    this.rbCedulaIdentidad.setSelected(false);
                } else {
                    this.rbCedulaIdentidad.setSelected(true);
                    this.rbTokenAbitab.setSelected(false);
                    this.rbTokenCorreo.setSelected(false);
                }
            }
        });
        this.rbTokenAbitab.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.rbTokenAbitab.isSelected()) {
                    this.rbTokenAbitab.setSelected(false);
                } else {
                    this.rbTokenAbitab.setSelected(true);
                    this.rbCedulaIdentidad.setSelected(false);
                    this.rbTokenCorreo.setSelected(false);
                }
            }
        });
        this.rbTokenCorreo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.rbTokenCorreo.isSelected()) {
                    this.rbTokenCorreo.setSelected(false);
                } else {
                    this.rbTokenCorreo.setSelected(true);
                    this.rbCedulaIdentidad.setSelected(false);
                    this.rbTokenAbitab.setSelected(false);
                }
            }
        });
    }
}

