/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.endpoints;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.dto.FirmaDTO;
import uy.ub.agesic.fd.dto.MensajesDTO;
import uy.ub.agesic.fd.dto.ProcesoDTO;
import uy.ub.agesic.fd.exceptions.BusinessException;
import uy.ub.agesic.fd.exceptions.TechnicalException;
import uy.ub.agesic.fd.holder.ProcesoHolder;

public class ClienteRest {
    ConfigurationUtil cfgUtil = new ConfigurationUtil(null);
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    private String URL = StringUtils.isBlank((CharSequence)this.holder.getParemeterUrl()) ? this.cfgUtil.getValue("FIRMAGUBUY_URL") : this.holder.getParemeterUrl();
    private final String URL_COMPLEMENT = "api/v1/aplicativo/";
    private final Client client;
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());

    public ClienteRest() {
        Preferences prefs = Preferences.userRoot().node("PREFERENCES");
        String host = prefs.get("HOST", "");
        String port = prefs.get("PORT", "");
        this.client = host != null && !host.equals("") && port != null && !port.equals("") ? ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().property("org.jboss.resteasy.jaxrs.client.proxy.host", (Object)host)).property("org.jboss.resteasy.jaxrs.client.proxy.port", (Object)port)).build() : ClientBuilder.newBuilder().build();
        logger.log(Level.INFO, "FIRMAGUBUY_ESTADISTICA_URL: {0} ", this.holder.getCustomUrlEstadistica());
        if (StringUtils.isBlank((CharSequence)this.holder.getParemeterUrl()) && StringUtils.isNotBlank((CharSequence)this.holder.getCustomUrlEstadistica())) {
            this.URL = this.holder.getCustomUrlEstadistica();
            logger.log(Level.INFO, "Se cambio la URL de estadisticas por la personalizada {0}", this.URL);
        }
    }

    public ProcesoDTO getProceso(String identificador, String claveSeguridad) throws Exception {
        logger.info("URL: " + this.URL);
        logger.info("identificador: " + identificador);
        logger.info("claveSeguridad: " + claveSeguridad);
        try {
            WebTarget target = this.client.target(this.URL).path("api/v1/aplicativo/").path(identificador);
            Response response = target.request(new String[]{"application/json"}).header("Authorization", (Object)claveSeguridad).get();
            logger.info("Respuesta del getProceso: " + response.getStatus());
            ProcesoDTO proceso = ClienteRest.procesarRespuesta(response, ProcesoDTO.class);
            if (proceso != null && !proceso.getArchivos().isEmpty()) {
                proceso.setIdentificador(identificador);
                proceso.setClaveSeguridad(claveSeguridad);
                return proceso;
            }
            return null;
        }
        catch (Exception e) {
            throw new TechnicalException(e);
        }
    }

    public InputStream getArchivo(String identificador, String claveSeguridad) throws Exception {
        try {
            WebTarget target = this.client.target(this.URL).path("api/v1/aplicativo/").path("archivo").path("/").path(identificador);
            Response response = target.request(new String[]{"application/octet-stream"}).header("Authorization", (Object)claveSeguridad).get();
            InputStream is = ClienteRest.procesarRespuesta(response, InputStream.class);
            return is;
        }
        catch (Exception e) {
            throw new TechnicalException(e);
        }
    }

    public MensajesDTO sendFileSigned(InputStream file, String identificadorFile) {
        try {
            WebTarget target = this.client.target(this.URL).path("api/v1/aplicativo/").path("archivo").path("/").path(identificadorFile);
            logger.log(Level.INFO, "------------> {0} - {1} - {2}", new Object[]{this.URL, "api/v1/aplicativo/", target.getUri().getPath()});
            Response response = target.request(new String[]{"application/json"}).header("Authorization", (Object)this.holder.getProceso().getClaveSeguridad()).post(Entity.entity((Object)file, (String)"application/octet-stream"));
            MensajesDTO mensaje = (MensajesDTO)response.readEntity(MensajesDTO.class);
            logger.log(Level.INFO, "Status de la respuesta -> {0}", response.getStatus());
            return mensaje;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception ", e);
            throw new TechnicalException(e);
        }
    }

    public Boolean finalizar(FirmaDTO dto) {
        int status = 0;
        try {
            logger.log(Level.INFO, "Finalizando firma con sistemas externos...");
            logger.log(Level.INFO, "FirmaDTO: {0}", dto.toString());
            WebTarget target = this.client.target(this.URL).path("api/v1/aplicativo/").path("finalizar");
            logger.log(Level.INFO, "URL: {0}{1}", new Object[]{this.URL, target.getUri().getPath()});
            Response response = target.request(new String[]{"application/json"}).post(Entity.entity((Object)dto, (String)"application/json"));
            status = response.getStatus();
            logger.log(Level.INFO, "Respuesta de finalizar proceso de firma, code:{0}, info:{1}", new Object[]{status, response.getStatusInfo()});
            return status == 200;
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, "Respuesta del finalizar proceso: Exception ", e);
                throw new TechnicalException(e);
            }
            catch (Throwable throwable) {
                return status == 200;
            }
        }
    }

    private static <T> T procesarRespuesta(Response response, Class<T> responseType) throws Exception {
        if (response.getStatus() >= 400) {
            if (response.getStatus() >= 500) {
                Exception ex = new Exception("ERROR_GENERAL");
                throw ex;
            }
            switch (response.getStatus()) {
                case 422: {
                    BusinessException be = (BusinessException)response.readEntity(BusinessException.class);
                    throw be;
                }
                case 403: {
                    BusinessException be = new BusinessException("ERROR_SEGURIDAD");
                    throw be;
                }
            }
            BusinessException be = new BusinessException("ERROR_INVOCACION_CLIENTE_" + response.getStatus());
            throw be;
        }
        if (responseType == null) {
            return null;
        }
        return (T)response.readEntity(responseType);
    }

    public String validateVersion(String version) {
        try {
            WebTarget target = this.client.target(this.URL).path("api/v1/aplicativo/").path("version").path("/").path(version);
            logger.log(Level.INFO, "URL: {0}{1}", new Object[]{this.URL, target.getUri().getPath()});
            Response response = target.request(new String[]{"text/plain"}).get();
            String resp = (String)response.readEntity(String.class);
            return resp;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "validateVersion exception", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSignStatistics(FirmaDTO dto) {
        int status = 0;
        try {
            logger.log(Level.INFO, "FirmaDTO: {0}", dto.toString());
            WebTarget target = this.client.target(this.URL).path("api/v1/aplicativo/").path("estadisticas");
            logger.log(Level.INFO, "URL: {0}{1}", new Object[]{this.URL, target.getUri().getPath()});
            String json = new ObjectMapper().writeValueAsString((Object)dto);
            logger.log(Level.INFO, "FirmaDTO: {0}", json);
            Response response = target.request(new String[]{"application/json"}).post(Entity.entity((Object)json, (String)"application/json"));
            status = response.getStatus();
            logger.log(Level.INFO, "Respuesta del guardado de estadisticas: {0}", status);
            return status == 200;
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, "Respuesta del guardado de estadisticas: Exception ", e);
                return status == 200;
            }
            catch (Throwable throwable) {
                return status == 200;
            }
        }
    }
}

