/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.icepdf;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.PageViewComponent;

public class SofisAnnotationCallback
extends MyAnnotationCallback {
    private static final Logger logger = Logger.getLogger(SofisAnnotationCallback.class.toString());
    private final String identificadorProceso;
    private final boolean debug;

    public SofisAnnotationCallback(DocumentViewController documentViewController, String identificadorProceso, boolean debug) {
        super(documentViewController);
        this.identificadorProceso = identificadorProceso;
        this.debug = debug;
    }

    public void processAnnotationAction(Annotation annotation, Action action, int x, int y) {
        super.processAnnotationAction(annotation, action, x, y);
    }

    public void pageAnnotationsInitialized(Page page) {
        super.pageAnnotationsInitialized(page);
    }

    public void newAnnotation(PageViewComponent pageComponent, AnnotationComponent annotationComponent) {
        this.imprimirAnotacion("new-1", annotationComponent.getAnnotation());
        annotationComponent.getAnnotation().getEntries().put("PFEA", this.identificadorProceso);
        super.newAnnotation(pageComponent, annotationComponent);
        this.imprimirAnotacion("new-2", annotationComponent.getAnnotation());
    }

    public void updateAnnotation(AnnotationComponent annotationComponent) {
        this.imprimirAnotacion("upd-1", annotationComponent.getAnnotation());
        super.updateAnnotation(annotationComponent);
        this.imprimirAnotacion("upd-2", annotationComponent.getAnnotation());
    }

    private void imprimirAnotacion(String t, Annotation a) {
        if (!this.debug) {
            return;
        }
        logger.log(Level.INFO, "====[{0}]==============================================", t);
        logger.log(Level.INFO, "getClass: {0}", a.getClass().getName());
        logger.log(Level.INFO, "getAction: {0}", a.getAction());
        logger.log(Level.INFO, "getContents: {0}", a.getContents());
        logger.log(Level.INFO, "toString: {0}", a);
        logger.log(Level.INFO, "getAppearances: {0}", a.getAppearances().keySet());
        logger.log(Level.INFO, "getBbox: {0}", a.getBbox());
        logger.log(Level.INFO, "getBorder: {0}", a.getBorder());
        logger.log(Level.INFO, "getBorderStyle: {0}", a.getBorderStyle());
        logger.log(Level.INFO, "getBorderStyleStroke: {0}", a.getBorderStyleStroke());
        logger.log(Level.INFO, "getBorderType: {0}", a.getBorderType());
        logger.log(Level.INFO, "getColor: {0}", a.getColor());
        logger.log(Level.INFO, "getCurrentAppearance: {0}", a.getCurrentAppearance());
        logger.log(Level.INFO, "getEntries: {0}", a.getEntries());
        if (a.getEntries() != null) {
            for (Object k : a.getEntries().keySet()) {
                logger.log(Level.INFO, "\t{0}={1}", new Object[]{k, a.getEntries().get(k)});
            }
        }
        logger.log(Level.INFO, "getFlagHidden: {0}", a.getFlagHidden());
        logger.log(Level.INFO, "getFlagInvisible: {0}", a.getFlagInvisible());
        logger.log(Level.INFO, "getFlagLocked: {0}", a.getFlagLocked());
        logger.log(Level.INFO, "getFlagLockedContents: {0}", a.getFlagLockedContents());
        logger.log(Level.INFO, "getFlagNoRotate: {0}", a.getFlagNoRotate());
        logger.log(Level.INFO, "getFlagNoView: {0}", a.getFlagNoView());
        logger.log(Level.INFO, "getFlagNoZoom: {0}", a.getFlagNoZoom());
        logger.log(Level.INFO, "getFlagPrint: {0}", a.getFlagPrint());
        logger.log(Level.INFO, "getFlagReadOnly: {0}", a.getFlagReadOnly());
        logger.log(Level.INFO, "getFlagToggleNoView: {0}", a.getFlagToggleNoView());
        logger.log(Level.INFO, "getLibrary: {0}", a.getLibrary());
        logger.log(Level.INFO, "getLineStyle: {0}", a.getLineStyle());
        logger.log(Level.INFO, "getLineThickness: {0}", Float.valueOf(a.getLineThickness()));
        logger.log(Level.INFO, "getParentAnnotation: {0}", a.getParentAnnotation());
        logger.log(Level.INFO, "getShapes: {0}", a.getShapes());
        if (a.getShapes() != null) {
            logger.log(Level.INFO, "\tgetShapes: {0}", Float.valueOf(a.getShapes().getAlpha()));
            logger.log(Level.INFO, "\tgetShapes: {0}", a.getShapes().getImages());
            logger.log(Level.INFO, "\tgetShapes: {0}", a.getShapes().getPageText());
            logger.log(Level.INFO, "\tgetShapes: {0}", a.getShapes().getRule());
            logger.log(Level.INFO, "\tgetShapes: {0}", a.getShapes().getShapes());
            logger.log(Level.INFO, "\tgetShapes: {0}", a.getShapes().getShapesCount());
        }
        logger.log(Level.INFO, "getSubType: {0}", a.getSubType());
        logger.log(Level.INFO, "getUserSpaceRectangle: {0}", a.getUserSpaceRectangle());
        if (a instanceof SquareAnnotation) {
            SquareAnnotation sa = (SquareAnnotation)a;
            logger.log(Level.INFO, "getRectangle: {0}", sa.getRectangle());
        }
    }

    public void removeAnnotation(PageViewComponent pageComponent, AnnotationComponent annotationComponent) {
        super.removeAnnotation(pageComponent, annotationComponent);
    }
}

