/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.store.browser;

import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.mozilla.MozillaStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.exceptions.DriverException;
import uy.ub.agesic.fd.exceptions.StoreException;
import uy.ub.agesic.fd.exceptions.StoreInvalidPasswordException;
import uy.ub.agesic.fd.store.CertStoreI;
import uy.ub.agesic.fd.store.SofisCertificate;

public class MozillaCertStoreImpl
implements CertStoreI {
    MozillaStore bstore = null;
    private String profile = "";
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());

    public MozillaCertStoreImpl(String profileParam) throws StoreException {
        try {
            this.profile = profileParam;
        }
        catch (Exception ex) {
            throw new StoreException(ex);
        }
    }

    private static String getCertificateIdentificacion(String sdn) {
        StringTokenizer stk = new StringTokenizer(sdn, ",");
        String respuesta = null;
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (!token.contains("SERIALNUMBER")) continue;
            String[] partes = token.split("=");
            respuesta = partes[1];
            break;
        }
        return respuesta;
    }

    @Override
    public List<SofisCertificate> getSignCertificateFromStore() throws StoreException {
        ArrayList<SofisCertificate> toReturn = new ArrayList<SofisCertificate>();
        try {
            this.bstore = new MozillaStore(this.profile);
            List lista = this.bstore.getSignCertificates();
            String cn = null;
            int pos = 0;
            for (X509Certificate c : lista) {
                if (cn == null) {
                    try {
                        String[] aux = c.getSubjectDN().getName().split(",");
                        cn = aux[0].trim().split("=")[1];
                    }
                    catch (Exception w) {
                        cn = c.getSubjectDN().getName();
                    }
                }
                SofisCertificate cert = new SofisCertificate(cn, pos, c, (CertStoreI)this);
                toReturn.add(cert);
                ++pos;
            }
            return toReturn;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception ", ex);
            throw new StoreException(ex);
        }
    }

    @Override
    public PrivateKey getPrivateKey(SofisCertificate certificate, String certificatePass) throws StoreException {
        try {
            return this.bstore.getPrivateKey(certificate.getCertificate());
        }
        catch (CertStoreException ex) {
            throw new StoreException(ex);
        }
    }

    @Override
    public Provider getProvider(SofisCertificate certificate) {
        return this.bstore.getProvider(certificate.getCertificate());
    }

    @Override
    public List<SofisCertificate> getSignCertificateFromStore(String activeProvider) throws StoreException, DriverException, StoreInvalidPasswordException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

