/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.store.pkcs11;

import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.ConfigurationUtil;

public class PKCS11ConfigFile {
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    private ConfigurationUtil cfgUtil;
    static final String PATHS_SEPARATOR = ";";

    public PKCS11ConfigFile(ConfigurationUtil cfgUtil) {
        this.cfgUtil = cfgUtil;
    }

    public PKCS11 createConfigFile(String path, String token, UserAgent userAgent) throws IOException {
        File f;
        boolean isWindows = false;
        if (userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.UNKNOWN)) {
            String os = System.getProperty("os.name");
            isWindows = os != null && os.toLowerCase().indexOf("win") >= 0;
        }
        if (!(f = new File(path)).exists()) {
            logger.log(Level.INFO, "Creando archivo de configuraci\u00f3n para {0} en {1}", new Object[]{token, path});
            f.createNewFile();
        } else {
            logger.log(Level.INFO, "Eliminando archivo de configuraci\u00f3n para {0} en {1}", new Object[]{token, path});
            boolean deleted = f.delete();
            if (deleted) {
                logger.log(Level.INFO, "Creando archivo de configuraci\u00f3n para {0} en {1}", new Object[]{token, path});
                f.createNewFile();
            } else {
                logger.log(Level.INFO, "No se pudo eliminar el archivo de configuraci\u00f3n para {0} en {1}", new Object[]{token, path});
            }
        }
        if (isWindows || userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.WINDOWS)) {
            String paths = this.cfgUtil.getDriverPath(token.toUpperCase(), token.toUpperCase() + "_WIN");
            for (String dllPath : paths.split(PATHS_SEPARATOR)) {
                File flib;
                if ((dllPath = dllPath.trim()).length() <= 0 || !(flib = new File(dllPath)).exists() || !flib.canRead()) continue;
                this.writeFile(f, token, dllPath, false, null, userAgent);
                PKCS11 tokDriver = this.checkPath(dllPath, token);
                if (tokDriver == null) continue;
                return tokDriver;
            }
        } else {
            String paths = userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.LINUX) ? this.cfgUtil.getDriverPath(token.toUpperCase(), token.toUpperCase() + "_LIN") : this.cfgUtil.getDriverPath(token.toUpperCase(), token.toUpperCase() + "_MAC");
            for (String dllPath : paths.split(PATHS_SEPARATOR)) {
                PKCS11 tokDriver;
                if ((dllPath = dllPath.trim()).length() <= 0) continue;
                File flib = new File(dllPath);
                if (flib.exists() && flib.canRead()) {
                    this.writeFile(f, token, dllPath, false, "", userAgent);
                    tokDriver = this.checkPath(dllPath, token);
                    if (tokDriver == null) continue;
                    return tokDriver;
                }
                flib = new File(dllPath = dllPath.toLowerCase());
                if (!flib.exists() || !flib.canRead()) continue;
                this.writeFile(f, token, dllPath, false, "", userAgent);
                tokDriver = this.checkPath(dllPath, token);
                if (tokDriver == null) continue;
                return tokDriver;
            }
        }
        return null;
    }

    protected static Long slotInfo(String dllPksc11) throws Exception {
        int n = 0;
        PKCS11 p11 = PKCS11.getInstance(dllPksc11, "C_GetFunctionList", null, false);
        long[] slots = p11.C_GetSlotList(true);
        long[] lArray = slots;
        int n2 = lArray.length;
        if (n < n2) {
            long sl = lArray[n];
            CK_SLOT_INFO info = p11.C_GetSlotInfo(sl);
            logger.log(Level.INFO, "[{0}] Slot info: {1}", new Object[]{dllPksc11, info.toString()});
            return sl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File f, String name, String lib, boolean slot, String slotId, UserAgent userAgent) throws IOException {
        boolean isWindows = false;
        if (userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.UNKNOWN)) {
            String os = System.getProperty("os.name");
            isWindows = os != null && os.toLowerCase().indexOf("win") >= 0;
        }
        String lib1 = lib;
        if (isWindows || userAgent.getOperatingSystem().getGroup().equals((Object)OperatingSystem.WINDOWS)) {
            lib = lib.replace("\\", "\\\\");
            lib = "\"" + lib + "\"";
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f));
            out.write("name = " + name);
            out.newLine();
            out.write("library= " + lib);
            out.newLine();
            Long slotIdl = null;
            try {
                slotIdl = PKCS11ConfigFile.slotInfo(lib1);
            }
            catch (Exception ex) {
                logger.info("No se pudo obtener informacion del slot para:" + name);
            }
            if (slotIdl != null) {
                out.write("slot= " + slotIdl);
                out.newLine();
            } else if (slot && name.equalsIgnoreCase("aladdin")) {
                out.write("slot= " + slotId);
                out.newLine();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException ", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "IOException ", e);
                }
            }
        }
    }

    public PKCS11 checkPath(String dllPath, String token) {
        try {
            PKCS11 p11 = PKCS11.getInstance(dllPath, "C_GetFunctionList", null, false);
            return p11;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

