/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.store.pkcs11;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.PKCS11;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.store.pkcs11.PKCS11ConfigFile;

public class VerifyToken {
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    private ProcesoHolder holder = ProcesoHolder.getInstance();

    public int[] verificarTokens(String[] dispositivos) {
        int tokensInstalados = 0;
        int tokensConectados = 0;
        String sunPKCS11Str = "SunPKCS11-";
        try {
            String property = "java.io.tmpdir";
            String tempDir = System.getProperty(property);
            String pathSeparator = File.separator;
            if (!tempDir.endsWith(pathSeparator)) {
                tempDir = tempDir + pathSeparator;
            }
            for (String dispositivo : dispositivos) {
                String configFilePath;
                PKCS11ConfigFile f = new PKCS11ConfigFile(this.holder.getCfgUtil());
                PKCS11 sunPKCS = f.createConfigFile(configFilePath = tempDir + dispositivo + ".cfg", dispositivo, this.holder.getUserAgent());
                if (sunPKCS != null) {
                    logger.log(Level.INFO, "Dispositivo de " + dispositivo + " instalado.");
                    ++tokensInstalados;
                    try {
                        Security.removeProvider(sunPKCS11Str + dispositivo);
                        if (Security.getProvider(sunPKCS11Str + dispositivo) != null) continue;
                        SunPKCS11 sunPKCS11 = new SunPKCS11(configFilePath);
                        Security.addProvider(sunPKCS11);
                        Provider prov = Security.getProvider(sunPKCS11Str + dispositivo);
                        if (prov != null && !prov.getServices().isEmpty()) {
                            ++tokensConectados;
                            logger.log(Level.INFO, "Dispositivo de " + dispositivo + " conectado.");
                            continue;
                        }
                        logger.log(Level.INFO, "Dispositivo de " + dispositivo + " NO conectado.");
                    }
                    catch (ProviderException e) {
                        Throwable cause = e.getCause();
                        String message = e.getMessage();
                        if (message != null && message.contains("slotListIndex") || cause != null && cause.getMessage() != null && cause.getMessage().contains("slotListIndex")) {
                            logger.log(Level.WARNING, "No hay token/documento conectado {0}.", dispositivo);
                            continue;
                        }
                        logger.log(Level.SEVERE, "Error al inicializar el proveedor PKCS11", e);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "No se pudo acceder al token PKCS11", ex);
                    }
                    continue;
                }
                logger.log(Level.WARNING, "Dispositivo de {0} NO instalado.", dispositivo);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error al verificar el token para los dispositivos ", ex);
        }
        int[] ret = new int[]{tokensInstalados, tokensConectados};
        return ret;
    }
}

