/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.utils;

public class OSValidator {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase();
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase();

    public static boolean isWindows() {
        return OS_NAME.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS_NAME.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS_NAME.indexOf("nix") >= 0 || OS_NAME.indexOf("nux") >= 0 || OS_NAME.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OS_NAME.indexOf("sunos") >= 0;
    }

    public static String getOSName() {
        return OS_NAME;
    }

    public static String getOSCodeName() {
        if (OSValidator.isWindows()) {
            return "win";
        }
        if (OSValidator.isMac()) {
            return "osx";
        }
        if (OSValidator.isUnix()) {
            return "uni";
        }
        if (OSValidator.isSolaris()) {
            return "sol";
        }
        return "err";
    }

    public static String getOperatingSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return "WINDOWS".toLowerCase();
        }
        if (os.contains("nix") || os.contains("nux") || os.contains("aix")) {
            return "LINUX".toLowerCase();
        }
        if (os.contains("mac")) {
            return "MAC".toLowerCase();
        }
        return null;
    }

    public static String getOSArch() {
        return OS_ARCH;
    }

    public static String getOSVersion() {
        return OS_VERSION;
    }

    public static String getOSDetail() {
        return "name:" + OS_NAME + ", version:" + OS_VERSION + ", arch:" + OS_ARCH;
    }
}

