/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.utils;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.Event;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.controllers.FirmarController;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.utils.AlertasUtil;

public class StageUtil {
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    private StageHolder stageHolder = StageHolder.getInstance();
    ConfigurationUtil cfgUtil = new ConfigurationUtil(null);
    private Scene scene;
    private Stage stage;
    public final String version = this.cfgUtil.getValue("VERSION");
    public static final Integer WIDTH = 650;
    public static final Integer HEIGHT = 390;
    public static final Integer WIDTH_ALERT = 650;
    public static final Integer WIDTH_ALERT_BIG = 680;
    public static final Integer HEIGHT_ALERT = 290;
    public static final Integer HEIGHT_ALERT_BIG = 330;
    public static final Integer WIDTH_VISOR_PDF = 1250;
    public static final Integer HEIGHT_VISOR_PDF = 700;
    public static String NAME = "firma.gub.uy";
    public static String TITLE;

    public StageUtil() {
        TITLE = NAME + " " + this.version;
    }

    public Parent loadFXML(String nameFxml) throws IOException {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(AppViewer.class.getResource(nameFxml + ".fxml"));
            return (Parent)fxmlLoader.load();
        }
        catch (IOException io) {
            Logger.getLogger(FirmarController.class.getName()).log(Level.SEVERE, null, io);
            AlertasUtil alerta = new AlertasUtil();
            alerta.displayAlertError("Error: ", io.getMessage());
            return null;
        }
    }

    public void open(String fxml, String title) throws IOException {
        try {
            Scene scene = new Scene(this.loadFXML(fxml));
            Stage dialogStage = new Stage();
            dialogStage.setTitle(title);
            dialogStage.isAlwaysOnTop();
            dialogStage.setScene(scene);
            Image icono2 = new Image(this.getClass().getResourceAsStream("/images/favicon.png"));
            dialogStage.getIcons().add((Object)icono2);
            dialogStage.setResizable(this.stageHolder.isResizable());
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.stageHolder.getStage());
            dialogStage.show();
            this.stageHolder.setStage(dialogStage);
        }
        catch (IOException io) {
            Logger.getLogger(FirmarController.class.getName()).log(Level.SEVERE, null, io);
            AlertasUtil alerta = new AlertasUtil();
            alerta.displayAlertError("Error", "Error al abrir la siguiente ventana --->" + fxml);
        }
    }

    public void open(Event event, String nameFxml) throws IOException {
        this.scene = new Scene(this.loadFXML(nameFxml));
        Stage dialogStage = new Stage();
        dialogStage.setTitle(TITLE);
        dialogStage.isAlwaysOnTop();
        dialogStage.setScene(this.scene);
        this.scene.getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
        Image icono = new Image(this.getClass().getResourceAsStream("/images/favicon.png"));
        dialogStage.getIcons().add((Object)icono);
        dialogStage.setResizable(this.stageHolder.isResizable());
        dialogStage.initModality(Modality.WINDOW_MODAL);
        dialogStage.initOwner((Window)this.stageHolder.getStage());
        dialogStage.show();
        this.stageHolder.setStage(dialogStage);
    }

    public void openDialog(Event event, String nameFxml) throws IOException {
        this.scene = new Scene(this.loadFXML(nameFxml));
        Stage dialogStage = new Stage();
        dialogStage.setTitle(TITLE);
        dialogStage.isAlwaysOnTop();
        dialogStage.setScene(this.scene);
        this.scene.getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
        Image icono = new Image(this.getClass().getResourceAsStream("/images/favicon.png"));
        dialogStage.getIcons().add((Object)icono);
        dialogStage.setResizable(this.stageHolder.isResizable());
        dialogStage.initModality(Modality.WINDOW_MODAL);
        dialogStage.initOwner((Window)this.stageHolder.getStage());
        dialogStage.show();
    }

    public void openShowAndWait(Event event, String nameFxml) throws IOException {
        this.scene = new Scene(this.loadFXML(nameFxml));
        Stage dialogStage = new Stage();
        dialogStage.setTitle(TITLE);
        dialogStage.isAlwaysOnTop();
        dialogStage.setScene(this.scene);
        this.scene.getStylesheets().add((Object)this.getClass().getResource("/css/style.css").toExternalForm());
        Image icono = new Image(this.getClass().getResourceAsStream("/images/favicon.png"));
        dialogStage.getIcons().add((Object)icono);
        dialogStage.setResizable(this.stageHolder.isResizable());
        dialogStage.initModality(Modality.WINDOW_MODAL);
        dialogStage.initOwner((Window)this.stageHolder.getStage());
        dialogStage.showAndWait();
    }

    public void close(Event event) {
        Node nodeClose = (Node)event.getSource();
        this.stage = new Stage();
        this.stage = (Stage)nodeClose.getScene().getWindow();
        this.stage.close();
    }

    public void openLoading() throws IOException {
        Stage dialogStage = new Stage();
        StackPane root = new StackPane();
        Image image = new Image(this.getClass().getResourceAsStream("/images/loader.gif"));
        ImageView imageView = new ImageView(image);
        Text textDescription = new Text();
        textDescription.setText("Firmando lote de  archivos");
        textDescription.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)24.0));
        textDescription.setStyle("-fx-font-size: 20px;");
        textDescription.setTextAlignment(TextAlignment.CENTER);
        root.getChildren().addAll((Object[])new Node[]{imageView});
        StackPane.setAlignment((Node)imageView, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)textDescription, (Pos)Pos.CENTER);
        Scene scene = new Scene((Parent)root, 450.0, 300.0);
        dialogStage.setScene(scene);
        dialogStage.setResizable(this.stageHolder.isResizable());
        dialogStage.initStyle(StageStyle.TRANSPARENT);
        dialogStage.initModality(Modality.WINDOW_MODAL);
        dialogStage.initOwner((Window)this.stageHolder.getStage());
        dialogStage.show();
    }

    public void setStageTitle(String newTitle) {
        this.stage.setTitle(newTitle);
    }

    public Stage getStage() {
        return this.stage;
    }
}

