/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.xml;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.ValidarFirmaXML;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uy.ub.agesic.fd.business.validation.CARootValidation;
import uy.ub.agesic.fd.business.validation.CRLValidation;
import uy.ub.agesic.fd.business.validation.UserCertificateValidation;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.exceptions.CARootVerificationException;
import uy.ub.agesic.fd.exceptions.CRLVerificationException;
import uy.ub.agesic.fd.exceptions.SignException;
import uy.ub.agesic.fd.exceptions.StoreException;
import uy.ub.agesic.fd.exceptions.UserVerificationException;
import uy.ub.agesic.fd.store.SofisCertificate;
import uy.ub.agesic.fd.utils.SofisFile;
import xades4j.algorithms.Algorithm;
import xades4j.algorithms.EnvelopedSignatureTransform;
import xades4j.production.DataObjectReference;
import xades4j.production.SignedDataObjects;
import xades4j.production.XadesBesSigningProfile;
import xades4j.production.XadesSignatureResult;
import xades4j.production.XadesSigner;
import xades4j.properties.DataObjectDesc;
import xades4j.properties.DataObjectFormatProperty;
import xades4j.providers.KeyingDataProvider;
import xades4j.providers.impl.DirectKeyingDataProvider;

public class XMLSignatureImpl {
    private static final Logger logger = Logger.getLogger(XMLSignatureImpl.class.getName());

    public SofisFile signXML(SofisCertificate certificate, String certificatePassword, SofisFile xmlToSign, String user_data, HashMap<String, String> options) throws CertificateExpiredException, CertificateNotYetValidException, UserVerificationException, IOException, SignException, StoreException, CRLVerificationException, CARootVerificationException {
        ConfigurationUtil cfgUtil = new ConfigurationUtil(options);
        MessagesUtil msgUtil = new MessagesUtil(options);
        try {
            String xmlDoc = new String(xmlToSign.getBytes());
            Document doc = this.convertirDeXml(xmlDoc);
            boolean CRL_VALIDATION = cfgUtil.getBooleanValue("CRL_ENABLED");
            boolean CA_ROOT_VALIDATION = cfgUtil.getBooleanValue("CA_ROOT_VALIDATION_ENABLE");
            boolean USER_VALIDATION = cfgUtil.getBooleanValue("USER_VALIDATION_ENABLE");
            X509Certificate X509cert = certificate.getCertificate();
            PrivateKey privateKey = certificate.getStore().getPrivateKey(certificate, certificatePassword);
            DirectKeyingDataProvider kp = new DirectKeyingDataProvider(X509cert, privateKey);
            if (USER_VALIDATION) {
                UserCertificateValidation.validateCertificate(X509cert, user_data);
            }
            if (CRL_VALIDATION) {
                CRLValidation.validateCertificate(X509cert);
            }
            if (CA_ROOT_VALIDATION) {
                HashSet<X509Certificate> additionalCerts = null;
                try {
                    String password = cfgUtil.getValue("KEYSTORE_TRUSTORE_PASS");
                    additionalCerts = new HashSet<X509Certificate>();
                    KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    InputStream is = cfgUtil.getInputStream("KEYSTORE_TRUSTORE_NAME");
                    if (is != null) {
                        keystore.load(is, password.toCharArray());
                        PKIXParameters params = new PKIXParameters(keystore);
                        for (TrustAnchor ta : params.getTrustAnchors()) {
                            X509Certificate trustCert = ta.getTrustedCert();
                            additionalCerts.add(trustCert);
                        }
                    }
                }
                catch (Exception w) {
                    throw new CARootVerificationException(msgUtil.getValue("MSG_CARootValidation_ERROR_GENERAL"));
                }
                if (additionalCerts != null) {
                    CARootValidation.validateCertificate(X509cert, additionalCerts);
                } else {
                    throw new CARootVerificationException(msgUtil.getValue("MSG_CARootValidation_ERROR_GENERAL"));
                }
            }
            DataObjectDesc obj = new DataObjectReference("").withTransform((Algorithm)new EnvelopedSignatureTransform()).withDataObjectFormat(new DataObjectFormatProperty("text/xml"));
            XadesSigner signer = new XadesBesSigningProfile((KeyingDataProvider)kp).newSigner();
            XadesSignatureResult rs = signer.sign(new SignedDataObjects(new DataObjectDesc[]{obj}), (Node)doc.getDocumentElement());
            Document doc2 = rs.getSignature().getDocument();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult sr = new StreamResult(os);
            transformer.transform(source, sr);
            return new SofisFile(xmlToSign.getNombre(), xmlToSign.getIdentificadorFile(), os.toByteArray(), xmlToSign.getTipo());
        }
        catch (Exception w) {
            logger.log(Level.SEVERE, "Fallo la firma xml ", w);
            throw new SignException(w);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document convertirDeXml(String xml) throws Exception {
        try {
            DOMParser parser = new DOMParser();
            StringReader sr = new StringReader(xml);
            parser.parse(new InputSource(sr));
            Document doc = parser.getDocument();
            return doc;
        }
        catch (IOException ioEx) {
            throw new Exception("No se pudo leer correctamente el xml.", ioEx);
        }
        catch (SAXException sxEx) {
            throw new Exception("El formato del documento xml no es correcto.", sxEx);
        }
    }

    public boolean validarFirma2(File file) throws Exception {
        boolean ret;
        try {
            FileInputStream fileInputStream = null;
            byte[] bFile = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(bFile);
            fileInputStream.close();
            ValidarFirmaXML vxml = new ValidarFirmaXML();
            List coreValidity = vxml.validar(bFile, null);
            ret = ((ResultadoValidacion)coreValidity.get(0)).isValidate();
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = false;
        }
        return ret;
    }

    public boolean validarFirma(String xml) throws Exception {
        Document doc = this.convertirDeXml(xml);
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl == null || nl.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        DOMValidateContext valContext = new DOMValidateContext(new X509KeySelector(), nl.item(nl.getLength() - 1));
        XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = factory.unmarshalXMLSignature(valContext);
        boolean coreValidity = signature.validate(valContext);
        if (!coreValidity) {
            boolean sv = signature.getSignatureValue().validate(valContext);
            Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
            int j = 0;
            while (i.hasNext()) {
                boolean bl = i.next().validate(valContext);
                ++j;
            }
        }
        return coreValidity;
    }

    private class X509KeySelector
    extends KeySelector {
        private X509KeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            for (XMLStructure info : keyInfo.getContent()) {
                if (!(info instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)info;
                for (Object o : x509Data.getContent()) {
                    if (!(o instanceof X509Certificate)) continue;
                    final PublicKey key = ((X509Certificate)o).getPublicKey();
                    if (!this.algEquals(method.getAlgorithm(), key.getAlgorithm())) continue;
                    return new KeySelectorResult(){

                        @Override
                        public Key getKey() {
                            return key;
                        }
                    };
                }
            }
            throw new KeySelectorException("No key found!");
        }

        boolean algEquals(String algURI, String algName) {
            return algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

