/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import org.w3c.dom.Element;
import xades4j.algorithms.Algorithm;
import xades4j.production.DataGenBaseTimeStamp;
import xades4j.production.PropertiesDataGenerationContext;
import xades4j.properties.SignatureTimeStampProperty;
import xades4j.properties.data.BaseXAdESTimeStampData;
import xades4j.properties.data.SignatureTimeStampData;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.TimeStampTokenProvider;
import xades4j.utils.CannotAddDataToDigestInputException;
import xades4j.utils.DOMHelper;
import xades4j.utils.TimeStampDigestInput;
import xades4j.utils.TimeStampDigestInputFactory;

class DataGenSigTimeStamp
extends DataGenBaseTimeStamp<SignatureTimeStampProperty> {
    @Inject
    public DataGenSigTimeStamp(TimeStampTokenProvider timeStampTokenProvider, AlgorithmsProviderEx algorithmsProvider, TimeStampDigestInputFactory timeStampDigestInputFactory) {
        super(algorithmsProvider, timeStampTokenProvider, timeStampDigestInputFactory);
    }

    @Override
    protected void addPropSpecificTimeStampInput(SignatureTimeStampProperty prop, TimeStampDigestInput digestInput, PropertiesDataGenerationContext ctx) throws CannotAddDataToDigestInputException {
        Element sigValueElem = DOMHelper.getFirstDescendant(ctx.getTargetXmlSignature().getElement(), "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        digestInput.addNode(sigValueElem);
    }

    @Override
    protected BaseXAdESTimeStampData createPropDataObj(SignatureTimeStampProperty prop, Algorithm c14n, TimeStampTokenProvider.TimeStampTokenRes tsTknRes, PropertiesDataGenerationContext ctx) {
        prop.setTime(tsTknRes.timeStampTime);
        return new SignatureTimeStampData(c14n, tsTknRes.encodedTimeStampToken);
    }
}

