/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import xades4j.XAdES4jException;
import xades4j.production.PropertiesDataObjectsGenerator;
import xades4j.production.SignedDataObjectsProcessor;
import xades4j.production.SignerBES;
import xades4j.properties.SignedSignatureProperty;
import xades4j.properties.UnsignedSignatureProperty;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.BasicSignatureOptionsProvider;
import xades4j.providers.DataObjectPropertiesProvider;
import xades4j.providers.KeyingDataProvider;
import xades4j.providers.SignaturePolicyInfoProvider;
import xades4j.providers.SignaturePropertiesProvider;
import xades4j.utils.PropertiesUtils;
import xades4j.xml.marshalling.SignedPropertiesMarshaller;
import xades4j.xml.marshalling.UnsignedPropertiesMarshaller;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

class SignerEPES
extends SignerBES {
    private final SignaturePolicyInfoProvider policyInfoProvider;

    @Inject
    protected SignerEPES(KeyingDataProvider keyingProvider, AlgorithmsProviderEx algorithmsProvider, BasicSignatureOptionsProvider basicSignatureOptionsProvider, SignedDataObjectsProcessor dataObjectDescsProcessor, SignaturePolicyInfoProvider policyInfoProvider, SignaturePropertiesProvider signaturePropsProvider, DataObjectPropertiesProvider dataObjPropsProvider, PropertiesDataObjectsGenerator propsDataObjectsGenerator, SignedPropertiesMarshaller signedPropsMarshaller, UnsignedPropertiesMarshaller unsignedPropsMarshaller, AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller) {
        super(keyingProvider, algorithmsProvider, basicSignatureOptionsProvider, dataObjectDescsProcessor, signaturePropsProvider, dataObjPropsProvider, propsDataObjectsGenerator, signedPropsMarshaller, unsignedPropsMarshaller, algorithmsParametersMarshaller);
        this.policyInfoProvider = policyInfoProvider;
    }

    @Override
    protected void getFormatSpecificSignatureProperties(Collection<SignedSignatureProperty> formatSpecificSignedSigProps, Collection<UnsignedSignatureProperty> formatSpecificUnsignedSigProps, List<X509Certificate> signingCertificateChain) throws XAdES4jException {
        super.getFormatSpecificSignatureProperties(formatSpecificSignedSigProps, formatSpecificUnsignedSigProps, signingCertificateChain);
        PropertiesUtils.addXadesEpesProperties(formatSpecificSignedSigProps, this.policyInfoProvider);
    }
}

