/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.HttpURLConnection;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.providers.impl.DefaultTimeStampTokenProvider;
import xades4j.providers.impl.TSAHttpAuthenticationData;
import xades4j.utils.Base64;

public final class AuthenticatedTimeStampTokenProvider
extends DefaultTimeStampTokenProvider {
    private final String base64tsaUsrAndPwd;

    @Inject
    public AuthenticatedTimeStampTokenProvider(MessageDigestEngineProvider messageDigestProvider, TSAHttpAuthenticationData httpAuthenticationData) {
        super(messageDigestProvider, httpAuthenticationData.getTsaUrl());
        String usrAndPwd = httpAuthenticationData.getTsaUser() + ":" + httpAuthenticationData.getTsaPassword();
        this.base64tsaUsrAndPwd = Base64.encodeBytes(usrAndPwd.getBytes());
    }

    @Override
    HttpURLConnection getHttpConnection() throws IOException {
        HttpURLConnection connection = super.getHttpConnection();
        connection.setRequestProperty("Authorization", "Basic " + this.base64tsaUsrAndPwd);
        return connection;
    }
}

