/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import xades4j.UnsupportedAlgorithmException;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.providers.TimeStampTokenGenerationException;
import xades4j.providers.TimeStampTokenProvider;

public class DefaultTimeStampTokenProvider
implements TimeStampTokenProvider {
    private static final Map<String, ASN1ObjectIdentifier> digestUriToOidMappings = new HashMap<String, ASN1ObjectIdentifier>(6);
    private final MessageDigestEngineProvider messageDigestProvider;
    private final TimeStampRequestGenerator tsRequestGenerator;
    private final String tsaUrl;

    private static ASN1ObjectIdentifier identifierForDigest(String digestAlgUri) {
        return digestUriToOidMappings.get(digestAlgUri);
    }

    @Inject
    public DefaultTimeStampTokenProvider(MessageDigestEngineProvider messageDigestProvider) {
        this(messageDigestProvider, "http://tss.accv.es:8318/tsa");
    }

    DefaultTimeStampTokenProvider(MessageDigestEngineProvider messageDigestProvider, String tsaUrl) {
        this.messageDigestProvider = messageDigestProvider;
        this.tsaUrl = tsaUrl;
        this.tsRequestGenerator = new TimeStampRequestGenerator();
        this.tsRequestGenerator.setCertReq(true);
    }

    @Override
    public final TimeStampTokenProvider.TimeStampTokenRes getTimeStampToken(byte[] tsDigestInput, String digestAlgUri) throws TimeStampTokenGenerationException {
        try {
            MessageDigest md = this.messageDigestProvider.getEngine(digestAlgUri);
            byte[] digest = md.digest(tsDigestInput);
            TimeStampRequest tsRequest = this.tsRequestGenerator.generate(DefaultTimeStampTokenProvider.identifierForDigest(digestAlgUri), digest, BigInteger.valueOf(System.currentTimeMillis()));
            InputStream responseStream = this.getResponse(tsRequest.getEncoded());
            TimeStampResponse tsResponse = new TimeStampResponse(responseStream);
            if (tsResponse.getStatus() != 0 && tsResponse.getStatus() != 1) {
                throw new TimeStampTokenGenerationException("Time stamp token not granted. " + tsResponse.getStatusString());
            }
            tsResponse.validate(tsRequest);
            TimeStampToken tsToken = tsResponse.getTimeStampToken();
            return new TimeStampTokenProvider.TimeStampTokenRes(tsToken.getEncoded(), tsToken.getTimeStampInfo().getGenTime());
        }
        catch (UnsupportedAlgorithmException ex) {
            throw new TimeStampTokenGenerationException("Digest algorithm not supported", ex);
        }
        catch (TSPException ex) {
            throw new TimeStampTokenGenerationException("Invalid time stamp response", ex);
        }
        catch (IOException ex) {
            throw new TimeStampTokenGenerationException("Encoding error", ex);
        }
    }

    private InputStream getResponse(byte[] encodedRequest) throws TimeStampTokenGenerationException {
        try {
            HttpURLConnection connection = this.getHttpConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/timestamp-query");
            connection.setRequestProperty("Content-length", String.valueOf(encodedRequest.length));
            OutputStream out = connection.getOutputStream();
            out.write(encodedRequest);
            out.flush();
            if (connection.getResponseCode() != 200) {
                throw new TimeStampTokenGenerationException(String.format("TSA returned HTTP %d %s", connection.getResponseCode(), connection.getResponseMessage()));
            }
            return new BufferedInputStream(connection.getInputStream());
        }
        catch (IOException ex) {
            throw new TimeStampTokenGenerationException("Error when connecting to the TSA", ex);
        }
    }

    HttpURLConnection getHttpConnection() throws IOException {
        URL url = new URL(this.getTSAUrl());
        return (HttpURLConnection)url.openConnection();
    }

    protected String getTSAUrl() {
        return this.tsaUrl;
    }

    static {
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmldsig-more#md5", TSPAlgorithms.MD5);
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmlenc#ripemd160", TSPAlgorithms.RIPEMD160);
        digestUriToOidMappings.put("http://www.w3.org/2000/09/xmldsig#sha1", TSPAlgorithms.SHA1);
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmlenc#sha256", TSPAlgorithms.SHA256);
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmldsig-more#sha384", TSPAlgorithms.SHA384);
        digestUriToOidMappings.put("http://www.w3.org/2001/04/xmlenc#sha512", TSPAlgorithms.SHA512);
    }
}

