/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.security.cert.X509Certificate;
import xades4j.properties.data.CertRef;
import xades4j.verification.SigningCertificateVerificationException;

public class SigningCertificateReferenceException
extends SigningCertificateVerificationException {
    private final X509Certificate certificate;
    private final CertRef certificateRef;
    private final String msg;

    public SigningCertificateReferenceException(X509Certificate certificate, CertRef certificateRef, Throwable cause) {
        super(cause);
        this.certificate = certificate;
        this.certificateRef = certificateRef;
        this.msg = "cannot verify reference for certificate " + certificate.getSubjectX500Principal().getName();
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public CertRef getCertificateRef() {
        return this.certificateRef;
    }

    @Override
    protected String getVerificationMessage() {
        return this.msg;
    }
}

