/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.util.Collection;
import xades4j.properties.AllDataObjsTimeStampProperty;
import xades4j.properties.IndividualDataObjsTimeStampProperty;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.SignatureTimeStampProperty;
import xades4j.utils.DataGetter;
import xades4j.verification.CustomSignatureVerifier;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.TimeStampCoherenceException;
import xades4j.verification.XAdESVerificationResult;

class TimeStampCoherenceVerifier
implements CustomSignatureVerifier {
    TimeStampCoherenceVerifier() {
    }

    @Override
    public void verify(XAdESVerificationResult verificationData, QualifyingPropertyVerificationContext ctx) throws TimeStampCoherenceException {
        DataGetter<QualifyingProperty> propsGetter = verificationData.getPropertiesFilter();
        Collection<SignatureTimeStampProperty> sigTimeStamps = propsGetter.getOfType(SignatureTimeStampProperty.class);
        Collection<AllDataObjsTimeStampProperty> allDataObjsTimeStamps = propsGetter.getOfType(AllDataObjsTimeStampProperty.class);
        Collection<IndividualDataObjsTimeStampProperty> indivDataObjsTimeStamps = propsGetter.getOfType(IndividualDataObjsTimeStampProperty.class);
        for (SignatureTimeStampProperty sigTs : sigTimeStamps) {
            for (IndividualDataObjsTimeStampProperty indivDObjTs : indivDataObjsTimeStamps) {
                if (!sigTs.getTime().before(indivDObjTs.getTime())) continue;
                throw new TimeStampCoherenceException("SignatureTimeStamp", "time-stamp not posterior to data objects time-stamps");
            }
            for (AllDataObjsTimeStampProperty allDObjTs : allDataObjsTimeStamps) {
                if (!sigTs.getTime().before(allDObjTs.getTime())) continue;
                throw new TimeStampCoherenceException("SignatureTimeStamp", "time-stamp not posterior to data objects time-stamps");
            }
        }
    }
}

