/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.keystore;

import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.IPassStoreKS;
import es.mityc.javasign.pkstore.keystore.KeyTool;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KSStore
implements IPKStoreManager {
    private KeyStore ks;
    private IPassStoreKS passHandler;
    private Provider provider;
    private char[] nullPassword = KeyTool.EMPTY_STRING;

    public KSStore(KeyStore keystore, IPassStoreKS passwordHandler) {
        this.ks = keystore;
        this.passHandler = passwordHandler;
        this.provider = keystore.getProvider();
    }

    public KSStore(KeyStore keystore, IPassStoreKS passwordHandler, char[] nullpass) {
        this.ks = keystore;
        this.passHandler = passwordHandler;
        this.provider = keystore.getProvider();
        this.nullPassword = nullpass;
    }

    public KSStore(KeyStore keystore, Provider specificProvider, IPassStoreKS passwordHandler) {
        this.ks = keystore;
        this.passHandler = passwordHandler;
        this.provider = specificProvider;
    }

    public KSStore(KeyStore keystore, Provider specificProvider, IPassStoreKS passwordHandler, char[] nullpass) {
        this.ks = keystore;
        this.passHandler = passwordHandler;
        this.provider = specificProvider;
        this.nullPassword = nullpass;
    }

    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        return KeyTool.findPrivateKey(this.ks, certificate, this.passHandler, this.nullPassword);
    }

    public Provider getProvider(X509Certificate cert) {
        return this.provider;
    }

    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        return KeyTool.getCertificatesWithKeys(this.ks);
    }

    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        return KeyTool.getTrustCertificates(this.ks);
    }
}

