/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.mitycstore.MITyCStore;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PKContextDialog
extends JDialog {
    Log logger = LogFactory.getLog(PKContextDialog.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private MITyCStore ks = null;
    private Frame owner = null;
    private JPanel panPrincipal = null;
    private JButton aceptarButton = null;
    private JRadioButton protectedRadio = null;
    private JRadioButton unprotectedRadio = null;
    private JLabel passLabel = null;
    private JPasswordField passField = null;
    private JCheckBox cachedCheck = null;
    private JCheckBox alertCheck = null;

    protected PKContextDialog(Frame ownerFrame, MITyCStore keyStore) {
        super(ownerFrame);
        this.owner = ownerFrame;
        this.ks = keyStore;
        this.dialogInit();
    }

    protected String getContext() {
        MITyCStore mITyCStore = this.ks;
        mITyCStore.getClass();
        MITyCStore.AliasFormat context = mITyCStore.new MITyCStore.AliasFormat("");
        boolean isPro = this.protectedRadio.isSelected();
        boolean isCached = this.cachedCheck.isSelected();
        boolean mayWarn = this.alertCheck.isSelected();
        return context.genAliasPrefix(isPro, isCached, mayWarn);
    }

    protected char[] getPass() {
        return this.passField.getPassword();
    }

    protected void dialogInit() {
        super.dialogInit();
        this.panPrincipal = new JPanel();
        this.panPrincipal.setBorder(BorderFactory.createTitledBorder(I18N.getLocalMessage("i18n.mityc.cert.mityc.18")));
        this.protectedRadio = new JRadioButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.19"));
        this.passLabel = new JLabel(I18N.getLocalMessage("i18n.mityc.cert.mityc.20"));
        this.passField = new JPasswordField();
        this.cachedCheck = new JCheckBox(I18N.getLocalMessage("i18n.mityc.cert.mityc.21"));
        this.unprotectedRadio = new JRadioButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.22"));
        this.alertCheck = new JCheckBox(I18N.getLocalMessage("i18n.mityc.cert.mityc.23"));
        this.aceptarButton = new JButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.protectedRadio);
        group.add(this.unprotectedRadio);
        this.protectedRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean sel = ((JRadioButton)e.getSource()).isSelected();
                PKContextDialog.this.passLabel.setEnabled(sel);
                PKContextDialog.this.passField.setEnabled(sel);
                PKContextDialog.this.cachedCheck.setEnabled(sel);
                PKContextDialog.this.panPrincipal.repaint();
            }
        });
        this.unprotectedRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PKContextDialog.this.alertCheck.setEnabled(((JRadioButton)e.getSource()).isSelected());
                PKContextDialog.this.panPrincipal.repaint();
            }
        });
        this.protectedRadio.setSelected(true);
        this.alertCheck.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.panPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints protectedRadioConstraints = new GridBagConstraints();
        protectedRadioConstraints.gridx = 0;
        protectedRadioConstraints.gridy = 0;
        protectedRadioConstraints.weightx = 1.0;
        protectedRadioConstraints.gridwidth = 4;
        protectedRadioConstraints.fill = 2;
        protectedRadioConstraints.insets = new Insets(3, 10, 0, 0);
        this.panPrincipal.add((Component)this.protectedRadio, protectedRadioConstraints);
        GridBagConstraints passLabelConstraints = new GridBagConstraints();
        passLabelConstraints.gridx = 1;
        passLabelConstraints.gridy = 1;
        passLabelConstraints.insets = new Insets(3, 30, 0, 5);
        this.panPrincipal.add((Component)this.passLabel, passLabelConstraints);
        GridBagConstraints passFieldConstraints = new GridBagConstraints();
        passFieldConstraints.gridx = 2;
        passFieldConstraints.gridy = 1;
        passFieldConstraints.weightx = 1.0;
        passFieldConstraints.gridwidth = 2;
        passFieldConstraints.fill = 2;
        passFieldConstraints.insets = new Insets(3, 0, 2, 20);
        this.panPrincipal.add((Component)this.passField, passFieldConstraints);
        GridBagConstraints cachedCheckConstraints = new GridBagConstraints();
        cachedCheckConstraints.gridx = 2;
        cachedCheckConstraints.gridy = 2;
        cachedCheckConstraints.weightx = 1.0;
        cachedCheckConstraints.weighty = 1.0;
        cachedCheckConstraints.gridwidth = 4;
        cachedCheckConstraints.fill = 2;
        this.panPrincipal.add((Component)this.cachedCheck, cachedCheckConstraints);
        GridBagConstraints unprotectedRadioConstraints = new GridBagConstraints();
        unprotectedRadioConstraints.gridx = 0;
        unprotectedRadioConstraints.gridy = 3;
        unprotectedRadioConstraints.weightx = 1.0;
        unprotectedRadioConstraints.gridwidth = 4;
        unprotectedRadioConstraints.fill = 2;
        unprotectedRadioConstraints.insets = new Insets(5, 10, 0, 0);
        this.panPrincipal.add((Component)this.unprotectedRadio, unprotectedRadioConstraints);
        GridBagConstraints alertCheckConstraints = new GridBagConstraints();
        alertCheckConstraints.gridx = 2;
        alertCheckConstraints.gridy = 4;
        alertCheckConstraints.weightx = 1.0;
        alertCheckConstraints.gridwidth = 2;
        alertCheckConstraints.fill = 2;
        this.panPrincipal.add((Component)this.alertCheck, alertCheckConstraints);
        GridBagConstraints aceptarButtonConstraints = new GridBagConstraints();
        aceptarButtonConstraints.gridx = 2;
        aceptarButtonConstraints.gridy = 5;
        aceptarButtonConstraints.insets = new Insets(30, 60, 10, 0);
        this.aceptarButton.setText(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.accept"));
        this.aceptarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PKContextDialog.this.jAceptarButtonActionPerformed();
            }
        });
        this.panPrincipal.add((Component)this.aceptarButton, aceptarButtonConstraints);
        GridBagConstraints panPrincipalConstraints = new GridBagConstraints();
        panPrincipalConstraints.fill = 1;
        panPrincipalConstraints.weightx = 1.0;
        panPrincipalConstraints.weighty = 1.0;
        this.add((Component)this.panPrincipal, panPrincipalConstraints);
        this.setTitle(I18N.getLocalMessage("i18n.mityc.cert.mityc.24"));
        this.setSize(400, 250);
        this.setLocationRelativeTo(this.owner);
        if (this.owner == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        }
        this.setModal(true);
        this.setResizable(false);
    }

    private void jAceptarButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }
}

