/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore.mantainer;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreMaintainer;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.mitycstore.MITyCStore;
import es.mityc.javasign.pkstore.mitycstore.mantainer.KSManagerPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class KSManagerDialog
extends JDialog {
    private static final Log LOG = LogFactory.getLog(KSManagerDialog.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static final int WIDTH = 600;
    private static final int HEIGHT = 500;
    private JMenuBar menuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem loadItem = null;
    private JMenuItem exitMenuItem = null;
    private JMenu helpMenu = null;
    private JMenuItem showHelpMenuItem = null;
    private JButton acceptBtn = null;
    private JButton cancelBtn = null;
    private JSeparator statusPanelSeparator = null;
    private JPanel statusPanel = null;
    private JProgressBar progressBar = null;
    private KSManagerPanel ksmp = null;
    private Frame owner = null;
    private static KSManagerDialog ksm = null;

    public static KSManagerDialog getInstance(Frame owner, boolean modal, IPKStoreManager pksm, IPKStoreMaintainer pksma) {
        if (ksm == null) {
            ksm = new KSManagerDialog(owner, modal, pksm, pksma);
        }
        return ksm;
    }

    private KSManagerDialog(Frame own, boolean modal, IPKStoreManager pksm, IPKStoreMaintainer pksma) {
        super(own, I18N.getLocalMessage("i18n.mityc.cert.mityc.57"), modal);
        this.owner = own;
        this.dialogInit(pksm, pksma);
    }

    protected void dialogInit(IPKStoreManager pksm, IPKStoreMaintainer pksma) {
        block3: {
            try {
                this.ksmp = new KSManagerPanel(this.owner, pksm, pksma);
                AbstractAction loadAction = new AbstractAction("load"){

                    public void actionPerformed(ActionEvent arg0) {
                        File fichero = null;
                        FileDialog fd = new FileDialog((Dialog)ksm, I18N.getLocalMessage("i18n.mityc.cert.mityc.58"), 0);
                        fd.setFilenameFilter(new PropFilter());
                        fd.setVisible(true);
                        try {
                            fichero = new File(fd.getFile());
                        }
                        catch (NullPointerException e) {
                            return;
                        }
                        if (fichero != null && fichero.exists()) {
                            try {
                                MITyCStore ksMityc = new MITyCStore(new FileInputStream(fichero.getAbsolutePath()), false);
                                KSManagerDialog.this.ksmp = new KSManagerPanel(KSManagerDialog.this.owner, ksMityc, ksMityc);
                                KSManagerDialog.this.ksmp.repaint();
                            }
                            catch (CertStoreException e) {
                                JOptionPane.showMessageDialog(ksm, I18N.getLocalMessage("i18n.mityc.cert.mityc.59"), I18N.getLocalMessage("i18n.mityc.cert.mityc.15"), 0);
                                return;
                            }
                            catch (FileNotFoundException e) {
                                JOptionPane.showMessageDialog(ksm, I18N.getLocalMessage("i18n.mityc.cert.mityc.59"), I18N.getLocalMessage("i18n.mityc.cert.mityc.15"), 0);
                                return;
                            }
                        }
                    }
                };
                AbstractAction quitAction = new AbstractAction("quit"){

                    public void actionPerformed(ActionEvent e) {
                        ksm.setVisible(false);
                        ksm.dispose();
                    }
                };
                AbstractAction showHelpAction = new AbstractAction("showHelp"){

                    public void actionPerformed(ActionEvent arg0) {
                    }
                };
                this.menuBar = new JMenuBar();
                this.menuBar.setName("menuBar");
                this.fileMenu = new JMenu();
                this.fileMenu.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.60"));
                this.fileMenu.setName("fileMenu");
                this.loadItem = new JMenuItem();
                this.loadItem.setAction(loadAction);
                this.loadItem.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.61"));
                this.loadItem.setName("LoadMenuItem");
                this.fileMenu.add(this.loadItem);
                this.fileMenu.addSeparator();
                this.exitMenuItem = new JMenuItem();
                this.exitMenuItem.setAction(quitAction);
                this.exitMenuItem.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.62"));
                this.exitMenuItem.setName("exitMenuItem");
                this.fileMenu.add(this.exitMenuItem);
                this.menuBar.add(this.fileMenu);
                this.helpMenu = new JMenu();
                this.helpMenu.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.63"));
                this.helpMenu.setName("helpMenu");
                this.showHelpMenuItem = new JMenuItem();
                this.showHelpMenuItem.setAction(showHelpAction);
                this.showHelpMenuItem.setName("exitMenuItem");
                this.showHelpMenuItem.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.64"));
                this.helpMenu.add(this.showHelpMenuItem);
                this.menuBar.add(this.helpMenu);
                this.acceptBtn = new JButton();
                this.acceptBtn.setAction(null);
                this.acceptBtn.setMnemonic(10);
                this.acceptBtn.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.65"));
                this.acceptBtn.setVisible(false);
                this.cancelBtn = new JButton();
                this.cancelBtn.setAction(quitAction);
                this.cancelBtn.setMnemonic(27);
                this.cancelBtn.setText(I18N.getLocalMessage("i18n.mityc.cert.mityc.62"));
                this.statusPanel = new JPanel();
                this.statusPanelSeparator = new JSeparator();
                this.progressBar = new JProgressBar();
                this.statusPanel.setLayout(new GridBagLayout());
                GridBagConstraints statusGrid = new GridBagConstraints();
                statusGrid.gridx = 0;
                statusGrid.gridy = 0;
                statusGrid.gridwidth = 6;
                statusGrid.fill = 2;
                statusGrid.weightx = 1.0;
                statusGrid.insets = new Insets(0, 10, 0, 10);
                this.statusPanel.add((Component)this.statusPanelSeparator, statusGrid);
                GridBagConstraints progressGrid = new GridBagConstraints();
                progressGrid.gridx = 0;
                progressGrid.gridy = 1;
                progressGrid.insets = new Insets(8, 480, 0, 10);
                progressGrid.ipadx = 70;
                this.statusPanel.add((Component)this.progressBar, progressGrid);
                this.setLayout(new GridBagLayout());
                GridBagConstraints mainPanelGrid = new GridBagConstraints();
                mainPanelGrid.gridx = 0;
                mainPanelGrid.gridy = 0;
                mainPanelGrid.gridwidth = 4;
                mainPanelGrid.insets = new Insets(10, 10, 10, 10);
                mainPanelGrid.fill = 1;
                mainPanelGrid.weightx = 1.0;
                mainPanelGrid.weighty = 1.0;
                this.add((Component)this.ksmp, mainPanelGrid);
                GridBagConstraints accBtnGrid = new GridBagConstraints();
                accBtnGrid.gridx = 2;
                accBtnGrid.gridy = 1;
                accBtnGrid.insets = new Insets(10, 130, 10, 10);
                this.add((Component)this.acceptBtn, accBtnGrid);
                GridBagConstraints cancBtnGrid = new GridBagConstraints();
                cancBtnGrid.gridx = 3;
                cancBtnGrid.gridy = 1;
                cancBtnGrid.insets = new Insets(10, 20, 10, 10);
                this.add((Component)this.cancelBtn, cancBtnGrid);
                GridBagConstraints statusPanelGrid = new GridBagConstraints();
                statusPanelGrid.gridx = 0;
                statusPanelGrid.gridy = 2;
                statusPanelGrid.gridwidth = 4;
                statusPanelGrid.fill = 2;
                statusPanelGrid.weightx = 1.0;
                statusPanelGrid.ipady = 10;
                this.add((Component)this.statusPanel, statusPanelGrid);
                this.setJMenuBar(this.menuBar);
                this.setBackground(this.ksmp.getBackground());
                this.setLocationRelativeTo(this.owner);
                this.setSize(600, 500);
                if (this.owner == null) {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
                }
                this.setResizable(false);
                this.setDefaultCloseOperation(0);
                this.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        ksm.setVisible(false);
                        ksm.dispose();
                    }
                });
                this.doLayout();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.66", new Object[]{ex.getMessage()}));
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.66"), (Throwable)ex);
            }
        }
    }

    public static void main(String[] args) {
        File ficheroConf = new File(args[0]);
        try {
            MITyCStore mks = MITyCStore.getInstance(ficheroConf, true);
            KSManagerDialog manager = KSManagerDialog.getInstance(null, true, mks, mks);
            manager.setVisible(true);
        }
        catch (CertStoreException e) {
            e.printStackTrace();
        }
    }

    private class PropFilter
    implements FilenameFilter {
        private PropFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".properties");
        }
    }
}

