/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.elementos.xades.ObjectIdentifier;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.xml.xades.ReferenceProxy;
import es.mityc.javasign.xml.xades.TransformProxy;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatosNodosFirmados {
    private static final Log LOGGER = LogFactory.getLog(DatosNodosFirmados.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibXAdES");
    private static final String XPOINTER_ID = "#xpointer(id('";
    private static final String XPOINTER_ROOT = "#xpointer(/)";
    private ObjectIdentifier oi;
    private String desc;
    private String mimeType;
    private URI encoding;
    private ReferenceProxy reference;

    public DatosNodosFirmados() {
    }

    public DatosNodosFirmados(ObjectIdentifier oi, String desc, String mimeType, URI encoding) {
        this.oi = oi;
        this.desc = desc;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public void setReference(ReferenceProxy ref) {
        Element el;
        NombreNodo nn;
        this.reference = ref;
        if (ref != null && !this.isExternalData() && (nn = new NombreNodo("xmlns", "Object")).equals(el = UtilidadTratarNodo.getElementById(ref.getElement().getOwnerDocument(), this.getId()))) {
            this.setMimeType(el.getAttribute("MimeType"));
            String data = el.getAttribute("Encoding");
            if (data != null) {
                try {
                    data = data.replace(" ", "%20");
                    this.setEncoding(new URI(data));
                }
                catch (URISyntaxException ex) {
                    LOGGER.warn((Object)I18N.getLocalMessage("i18n.mityc.xades.validate.9", new Object[]{ex.getMessage()}));
                }
            }
        }
    }

    public String getId() {
        String uri = this.getURI();
        return uri != null ? (uri.startsWith("#") ? (uri.startsWith(XPOINTER_ID) ? uri.substring(XPOINTER_ID.length(), uri.length() - 2) : uri.substring(1)) : uri) : null;
    }

    public String getIdReference() {
        return this.reference != null ? this.reference.getID() : null;
    }

    public Element getElementReference() {
        return this.reference != null ? this.reference.getElement() : null;
    }

    public ObjectIdentifier getObjectIdentifier() {
        return this.oi;
    }

    public void setObjectIdentifier(ObjectIdentifier oi) {
        this.oi = oi;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public URI getEncoding() {
        return this.encoding;
    }

    public void setEncoding(URI encoding) {
        this.encoding = encoding;
    }

    public String getURI() {
        return this.reference != null ? (XPOINTER_ROOT.equals(this.reference) ? "" : this.reference.getURI()) : null;
    }

    public List<TransformProxy> getTransforms() {
        return this.reference != null ? this.reference.getTransforms() : new ArrayList();
    }

    public boolean canBeModifiedByTransforms() {
        boolean modified = false;
        List<TransformProxy> trans = this.getTransforms();
        for (TransformProxy transform : trans) {
            String uri = transform.getURI();
            if (TransformProxy.isCanonicalization(transform) || uri.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) continue;
            modified = true;
            break;
        }
        return modified;
    }

    public byte[] getNodoFirmadoBytes() {
        return this.reference.getBytes();
    }

    public void writeBytesToStream(OutputStream os) throws IOException {
        this.reference.writeToStream(os);
    }

    public boolean isSignInternal() {
        Element el;
        String id;
        boolean res = false;
        if (!this.isExternalData() && this.reference != null && (id = this.getId()) != null && (el = UtilidadTratarNodo.getElementById(this.reference.getElement().getOwnerDocument(), id)) != null) {
            Element signature = (Element)this.reference.getElement().getParentNode().getParentNode();
            res = UtilidadTratarNodo.isChildNode(el, signature) ? !UtilidadTratarNodo.isChildNode(el, new NombreNodo("xmlns", "Object"), signature) : false;
        }
        return res;
    }

    public boolean isExternalData() {
        String uri;
        boolean res = false;
        if (this.reference != null && (uri = this.reference.getURI()) != null && !"".equals(uri) && !uri.startsWith("#")) {
            res = true;
        }
        return res;
    }
}

