/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CertificateValuesType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncapsulatedCRLValue;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLValuesType
extends AbstractXADESElement {
    private ArrayList<EncapsulatedCRLValue> crls;

    public CRLValuesType(XAdESSchemas schema) {
        super(schema);
    }

    public CRLValuesType(XAdESSchemas schema, ArrayList<EncapsulatedCRLValue> crls) {
        super(schema);
        this.crls = crls;
    }

    public void addEncapsulatedCRLValue(EncapsulatedCRLValue crl) {
        if (this.crls == null) {
            this.crls = new ArrayList();
        }
        this.crls.add(crl);
    }

    public ArrayList<EncapsulatedCRLValue> getEncapsulatedCRLValues() {
        return this.crls;
    }

    public void setEncapsulatedCRLValues(ArrayList<EncapsulatedCRLValue> crls) {
        this.crls = crls;
    }

    public void addCRL(X509CRL crl, String id) throws InvalidInfoNodeException {
        EncapsulatedCRLValue ecv = new EncapsulatedCRLValue(this.schema, id, crl);
        this.addEncapsulatedCRLValue(ecv);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CertificateValuesType) {
            CRLValuesType cvt = (CRLValuesType)obj;
            ArrayList<EncapsulatedCRLValue> comp = cvt.crls;
            if ((this.crls == null || this.crls.isEmpty()) && (comp == null || comp.isEmpty())) {
                return true;
            }
            if (this.crls != null && comp != null && this.crls.size() == comp.size()) {
                Iterator<EncapsulatedCRLValue> itThis = this.crls.iterator();
                Iterator<EncapsulatedCRLValue> itComp = comp.iterator();
                while (itThis.hasNext()) {
                    if (itThis.next().equals(itComp.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        NodeList nodos = element.getChildNodes();
        ArrayList<EncapsulatedCRLValue> temp = new ArrayList<EncapsulatedCRLValue>(nodos.getLength());
        for (int i = 0; i < nodos.getLength(); ++i) {
            Node nodo = nodos.item(i);
            if (CRLValuesType.isDecorationNode(nodo)) continue;
            if (nodo.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Hijo de CRLValuesType no es un elemento");
            }
            EncapsulatedCRLValue crl = new EncapsulatedCRLValue(this.schema);
            crl.load((Element)nodo);
            temp.add(crl);
        }
        if (temp.size() == 0) {
            throw new InvalidInfoNodeException("CRLValuesType debe tener al menos un hijo");
        }
        this.crls = temp;
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.crls == null || this.crls.size() == 0) {
            throw new InvalidInfoNodeException("CRLValuesType debe tener al menos un hijo");
        }
        Iterator<EncapsulatedCRLValue> it = this.crls.iterator();
        while (it.hasNext()) {
            element.appendChild(it.next().createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
    }

    @Override
    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }
}

