/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncapsulatedPKIDataType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncodingEnum;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.io.ByteArrayInputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncapsulatedCRLValue
extends EncapsulatedPKIDataType {
    public EncapsulatedCRLValue(XAdESSchemas schema) {
        super(schema);
    }

    public EncapsulatedCRLValue(XAdESSchemas schema, String id) {
        super(schema, id);
    }

    public EncapsulatedCRLValue(XAdESSchemas schema, String id, X509CRL crl) throws InvalidInfoNodeException {
        super(schema, id);
        try {
            this.setValue(new String(Base64Coder.encode(crl.getEncoded())));
        }
        catch (CRLException ex) {
            throw new InvalidInfoNodeException("Error al extraer la informaci\u00f3n de la crl", ex);
        }
    }

    public void load(Element element) throws InvalidInfoNodeException {
        X509CRL crl;
        this.checkElementName(element, this.schema.getSchemaUri(), "EncapsulatedCRLValue");
        super.load(element);
        EncodingEnum encoding = this.getEncoding();
        if (encoding != null && !encoding.equals((Object)EncodingEnum.DER_ENCODED)) {
            throw new InvalidInfoNodeException("El contenido de EncapsulatedCRLValue debe estar en la codificaci\u00f3n " + EncodingEnum.DER_ENCODED.getEncodingUri().toString());
        }
        try {
            crl = this.getX509CRL();
        }
        catch (CRLException ex) {
            throw new InvalidInfoNodeException("El contenido de EncapsulatedCRLValue no es un certificado X509 v\u00e1lido", ex);
        }
        if (crl == null) {
            throw new InvalidInfoNodeException("El contenido de EncapsulatedCRLValue no es un certificado X509 v\u00e1lido");
        }
    }

    public X509CRL getX509CRL() throws CRLException {
        String value = this.getValue();
        if (value != null) {
            CertificateFactory cf;
            byte[] data;
            try {
                data = Base64Coder.decode(value);
            }
            catch (IllegalArgumentException ex) {
                throw new CRLException("Contenido base64 de EncapsulatedCRLValue inv\u00e1lido", ex);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                cf = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException ex) {
                throw new CRLException(ex);
            }
            CRL crl = cf.generateCRL(bais);
            if (crl instanceof X509CRL) {
                return (X509CRL)crl;
            }
            throw new CRLException("Contenido base64 de EncapsulatedCRLValue no es una CRL del tipo X.509");
        }
        return null;
    }

    public void setX509Certificate(X509Certificate certificate) throws CertificateException {
        this.setValue(new String(Base64Coder.encode(certificate.getEncoded())));
    }

    public boolean isThisNode(Node node) {
        return this.isElementName(this.nodeToElement(node), this.schema.getSchemaUri(), "EncapsulatedCRLValue");
    }

    public Element createElement(Document doc, String namespaceXAdES) throws InvalidInfoNodeException {
        return super.createElement(doc, namespaceXAdES);
    }

    protected Element createElement(Document doc) throws InvalidInfoNodeException {
        Element res = doc.createElementNS(this.schema.getSchemaUri(), this.namespaceXAdES + ":" + "EncapsulatedCRLValue");
        super.addContent(res, this.namespaceXAdES);
        return res;
    }
}

