/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.macosx;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.IPassStoreKS;
import es.mityc.javasign.pkstore.NullPassStorePK;
import es.mityc.javasign.pkstore.keystore.KSStore;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacOSXStore
implements IPKStoreManager {
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static final String APPLE_KEYSTORE = "Apple";
    private static final char[] APPLE_EMPTY_STRING = "-".toCharArray();
    private IPKStoreManager pkStore;

    public MacOSXStore() throws CertStoreException {
        this((IPassStoreKS)new NullPassStorePK());
    }

    public MacOSXStore(IPassStoreKS passwordHandler) throws CertStoreException {
        try {
            KeyStore appleKs = KeyStore.getInstance("KeychainStore", APPLE_KEYSTORE);
            appleKs.load(null, null);
            this.pkStore = new KSStore(appleKs, passwordHandler, APPLE_EMPTY_STRING);
        }
        catch (NoSuchProviderException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.macosx.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.macosx.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.macosx.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CertificateException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.macosx.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.macosx.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    public Provider getProvider(X509Certificate cert) {
        return Security.getProvider("SunRsaSign");
    }

    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        return this.pkStore != null ? this.pkStore.getCertPath(certificate) : null;
    }

    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        return this.pkStore != null ? this.pkStore.getPrivateKey(certificate) : null;
    }

    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        return this.pkStore != null ? this.pkStore.getSignCertificates() : null;
    }

    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        return this.pkStore != null ? this.pkStore.getTrustCertificates() : null;
    }
}

