/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.Preferences;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.icepdf.ri.util.PropertiesManager;
import uy.ub.agesic.fd.business.services.ClientService;
import uy.ub.agesic.fd.config.AppletParams;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.controllers.DisplayFilesController;
import uy.ub.agesic.fd.dto.ProcesoDTO;
import uy.ub.agesic.fd.enums.MetodoFirmaEnum;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.OSValidator;
import uy.ub.agesic.fd.utils.OtherUtils;
import uy.ub.agesic.fd.utils.StageUtil;

public class AppViewer
extends Application {
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    PropertiesManager properties = new PropertiesManager(System.getProperties(), ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle"));
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    ConfigurationUtil cfgUtil = new ConfigurationUtil(null);
    MessagesUtil msgUtil = new MessagesUtil(null);
    private Preferences prefs = Preferences.userRoot().node("PREFERENCES");
    private static String os;
    private StageHolder stageHolder = StageHolder.getInstance();

    public static void main(String[] args) throws Exception {
        String rutaArchivoLog = System.getProperty("java.io.tmpdir");
        if (!rutaArchivoLog.endsWith(File.separator)) {
            rutaArchivoLog = rutaArchivoLog + File.separator;
        }
        rutaArchivoLog = rutaArchivoLog + "Firmagubuy.log";
        FileHandler logHandler = new FileHandler(rutaArchivoLog, true);
        logHandler.setFormatter(new SimpleFormatter());
        logger.addHandler(logHandler);
        logger.log(Level.INFO, "Archivo de log:: {0}", rutaArchivoLog);
        os = OSValidator.getOperatingSystem();
        logger.log(Level.INFO, "OS: {0}", os);
        AppViewer app = new AppViewer();
        app.setearParametros(args);
        AppViewer.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        Preferences prefs;
        this.devMode();
        this.urlCustomEstadistica();
        if (this.validarVersion(primaryStage)) {
            if (!this.isParameters()) {
                StageUtil stageUtil = new StageUtil();
                Scene scene = new Scene(stageUtil.loadFXML("SeleccionDispositivoFirma"));
                scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/css/style.css").toExternalForm());
                Image icono = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/favicon.png"));
                primaryStage.getIcons().add((Object)icono);
                primaryStage.setScene(scene);
                primaryStage.sizeToScene();
                primaryStage.centerOnScreen();
                primaryStage.setTitle(StageUtil.TITLE);
                primaryStage.setResizable(this.stageHolder.isResizable());
                this.stageHolder.setStage(primaryStage);
                primaryStage.show();
            } else {
                DisplayFilesController dispay = new DisplayFilesController();
                dispay.initialize(primaryStage);
            }
        }
        if (!(prefs = Preferences.userRoot().node("PREFERENCES")).get("YA_INGRESO_RESPUESTA_ESTADISTICAS", "").equals(Boolean.TRUE.toString())) {
            try {
                StageUtil stage = new StageUtil();
                ProcesoDTO proceso = new ProcesoDTO();
                String jxml = "ConfirmarTerminosYCondiciones";
                this.holder.setProceso(proceso);
                stage.open(jxml, "");
                return;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (StringUtils.isBlank((CharSequence)prefs.get("CUSTOMIZE_SIGNATURE", ""))) {
            prefs.put("CUSTOMIZE_SIGNATURE", "false");
        }
        if (StringUtils.isBlank((CharSequence)prefs.get("SIGN_INC_FIRMA_AVAZADA", ""))) {
            prefs.put("SIGN_INC_FIRMA_AVAZADA", "false");
        }
        if (StringUtils.isBlank((CharSequence)prefs.get("SIGN_INC_AUTORIDAD", ""))) {
            prefs.put("SIGN_INC_AUTORIDAD", "false");
        }
        if (StringUtils.isBlank((CharSequence)prefs.get("SIGN_INC_DOCUMENTO", ""))) {
            prefs.put("SIGN_INC_DOCUMENTO", "false");
        }
        if (StringUtils.isBlank((CharSequence)prefs.get("SIGN_INC_FECHA", ""))) {
            prefs.put("SIGN_INC_FECHA", "false");
        }
        if (StringUtils.isBlank((CharSequence)prefs.get("SIGN_INC_FIRMADO_POR", ""))) {
            prefs.put("SIGN_INC_FIRMADO_POR", "false");
        }
    }

    private String[] loadFileConfig(Stage primaryStage) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Seleccione el archivo .firmagubuy descargado de la plataforma");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Archivos PFEA (*.firmagubuy)", new String[]{"*.firmagubuy"});
        chooser.getExtensionFilters().add((Object)extFilter);
        File file = chooser.showOpenDialog((Window)primaryStage);
        if (file.exists()) {
            logger.log(Level.INFO, "Path de documento de configuraci\u00f3n {0}...", file.getAbsolutePath());
            return new String[]{file.getAbsolutePath()};
        }
        logger.log(Level.WARNING, "No se encontro documento de configuraci\u00f3n{0}...", "");
        System.exit(1);
        return new String[0];
    }

    private boolean isParameters() {
        return !StringUtils.isBlank((CharSequence)this.holder.getParemeterIdentifier()) && !StringUtils.isBlank((CharSequence)this.holder.getParemeterPassword()) && !StringUtils.isBlank((CharSequence)this.holder.getParemeterUrl());
    }

    private void setearParametros(String[] args) {
        try {
            if (args.length < 1) {
                logger.log(Level.WARNING, "Parametros no encontrados");
            } else {
                this.loadFile(args[0]);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Excepction ", e);
        }
    }

    private void opcionUploadFileConfing(Stage stage) throws Exception {
        this.setearParametros(this.loadFileConfig(stage));
        if (this.isParameters()) {
            if (this.validarVersion(stage)) {
                DisplayFilesController dispay = new DisplayFilesController();
                dispay.initialize(stage);
            }
        } else {
            logger.log(Level.WARNING, "No se encontro documento {0}...", "");
            System.exit(1);
        }
    }

    private boolean validarVersion(Stage primaryStage) throws Exception {
        try {
            String version = this.cfgUtil.getValue("VERSION");
            ClientService service = new ClientService();
            String response = service.validarVersion(version);
            if (response == null) {
                AlertasUtil alerta = new AlertasUtil();
                alerta.displayAlertWarningConProxy(this.msgUtil.getValue("MSG_FAIL_VALIDATE_VERSION_CON_PROXY"));
                return true;
            }
            if (response.startsWith("http://") || response.startsWith("https://") || response.startsWith("ftp://")) {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle(this.msgUtil.getValue("MSG_ALERT_HEADER_WARNING"));
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.getDialogPane().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/css/style.css").toExternalForm());
                alert.getDialogPane().getStyleClass().add((Object)"alerta2");
                ButtonType btnDescargar = new ButtonType(this.msgUtil.getValue("DOWNLOAD_HERE"), ButtonBar.ButtonData.OK_DONE);
                ButtonType btnSalir = new ButtonType(this.msgUtil.getValue("OUT"), ButtonBar.ButtonData.CANCEL_CLOSE);
                ButtonType btnContinuar = new ButtonType(this.msgUtil.getValue("DOWNLOAD_LATER"), ButtonBar.ButtonData.LEFT);
                ArrayList<ButtonType> btns = new ArrayList<ButtonType>();
                alert.setHeaderText(this.msgUtil.getValue("MSG_DESCRIPTION_DOWNLOAD"));
                alert.getDialogPane().setMinSize((double)StageUtil.WIDTH_ALERT.intValue(), (double)StageUtil.HEIGHT_ALERT.intValue());
                alert.setResizable(false);
                btns.add(btnDescargar);
                btns.add(btnContinuar);
                btns.add(btnSalir);
                alert.getButtonTypes().setAll(btns);
                Optional result = alert.showAndWait();
                if (result.isPresent() && result.get() == btnDescargar) {
                    this.openBrowser(response + os + "/firmagubuy.zip");
                    Platform.exit();
                    System.exit(0);
                } else if (result.isPresent() && result.get() == btnSalir) {
                    Platform.exit();
                    System.exit(0);
                } else if (result.isPresent() && result.get() == btnContinuar) {
                    AlertasUtil alerta = new AlertasUtil();
                    alerta.displayAlertWarning(this.msgUtil.getValue("MSG_VERSION_WARNING"));
                    return true;
                }
                return false;
            }
            if (response.equals("ok")) {
                return true;
            }
            AlertasUtil alerta = new AlertasUtil();
            alerta.displayAlertError(this.msgUtil.getValue("ERROR_INICIO"), this.msgUtil.getValue("MSG_FAIL_VERSION"));
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            return true;
        }
    }

    public void openBrowser(String url) {
        this.getHostServices().showDocument(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadFile(String path) throws IOException {
        BufferedReader bufferedReader = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            File file = null;
            String readLine = "";
            Integer lineNumber = 0;
            file = new File(path);
            bufferedReader = new BufferedReader(new FileReader(file));
            block18: while ((readLine = bufferedReader.readLine()) != null) {
                lines.add(readLine);
                Integer n = lineNumber;
                Integer n2 = lineNumber = Integer.valueOf(lineNumber + 1);
                switch (lineNumber) {
                    case 1: {
                        this.holder.setParemeterIdentifier(readLine.trim());
                        continue block18;
                    }
                    case 2: {
                        this.holder.setParemeterPassword(readLine.trim());
                        continue block18;
                    }
                    case 3: {
                        this.holder.setParemeterMetodo(MetodoFirmaEnum.valueOf(readLine.trim()));
                        continue block18;
                    }
                    case 4: {
                        this.holder.setParemeterUrl(readLine.trim());
                        continue block18;
                    }
                    case 5: {
                        this.holder.setParemeterSistema(readLine.trim());
                        continue block18;
                    }
                }
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "IOException ", ioe);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "IOException ", e);
                }
            }
        }
        return lines;
    }

    private void urlCustomEstadistica() {
        String rutaArchivo;
        File archivo;
        String userHome = System.getProperty("user.home");
        Path appDir = Paths.get(userHome, ".firmagubuy");
        File appDirFile = appDir.toFile();
        if (!appDirFile.exists()) {
            appDirFile.mkdirs();
        }
        if ((archivo = new File(rutaArchivo = appDirFile + "/.firmagubuy_url")).exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(archivo));){
                String linea = br.readLine();
                if (StringUtils.isNotBlank((CharSequence)linea)) {
                    this.holder.setCustomUrlEstadistica(linea);
                    return;
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        } else {
            System.out.println("El archivo para url estadistica no existe, no se hace nada.");
        }
    }

    private void devMode() throws Exception {
        String rutaArchivo;
        File archivo;
        String md = "c+p6DCnzZ3Cal4y/E8GNoF/QY9a8a+c3eoy8oCZCFfc=";
        String userHome = System.getProperty("user.home");
        Path appDir = Paths.get(userHome, ".firmagubuy");
        File appDirFile = appDir.toFile();
        if (!appDirFile.exists()) {
            appDirFile.mkdirs();
        }
        if ((archivo = new File(rutaArchivo = appDirFile + "/.firmagubuy_dev")).exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(archivo));){
                String value = br.readLine();
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    AppletParams.ACTIVAR_P12 = md.equals(OtherUtils.hashSHA256(value));
                    System.out.println("dev. mode on.");
                    return;
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

