/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.business.services;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.business.services.SignBackgroundWorkerService;
import uy.ub.agesic.fd.business.validation.ClientValidation;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.dto.ArchivosDTO;
import uy.ub.agesic.fd.dto.ProcesoDTO;
import uy.ub.agesic.fd.endpoints.ClienteRest;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.OSValidator;
import uy.ub.agesic.fd.utils.SignUtils;
import uy.ub.agesic.fd.utils.SofisFile;
import uy.ub.agesic.fd.utils.StageUtil;

public class ClientService {
    ProcesoHolder holder = ProcesoHolder.getInstance();
    MessagesUtil msgUtil = new MessagesUtil(null);
    AlertasUtil alerta = new AlertasUtil();
    private StageHolder stageHolder = StageHolder.getInstance();
    private static final Logger LOGGER = Logger.getLogger(AppViewer.class.getName());

    public void consultaProceso(String identificador, String claveSeguridad) throws Exception {
        try {
            ClienteRest restCliente = new ClienteRest();
            ArrayList<SofisFile> files = new ArrayList<SofisFile>();
            ProcesoDTO proceso = restCliente.getProceso(identificador, claveSeguridad);
            proceso.setMetodoFirma(this.holder.getParemeterMetodo());
            for (ArchivosDTO archivo : proceso.getArchivos()) {
                InputStream is = restCliente.getArchivo(archivo.getIdentificadorArchivo(), claveSeguridad);
                files.add(new SofisFile(archivo.getNombre(), archivo.getIdentificadorArchivo(), IOUtils.toByteArray((InputStream)is), "pdf"));
            }
            this.holder.setProceso(proceso);
            this.holder.setSofisFile(files);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "consultaProceso ", e);
        }
    }

    public String validarVersion(String version) throws Exception {
        try {
            ClienteRest restCliente = new ClienteRest();
            return restCliente.validateVersion(version);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error en validar version services: ", e);
            return null;
        }
    }

    public void firmar(ActionEvent event, KeyEvent ke) {
        try {
            StageUtil stageUtil;
            boolean match;
            ClientValidation validation;
            if (!StringUtils.isBlank((CharSequence)this.holder.getParemeterSistema()) && this.holder.getParemeterSistema().equalsIgnoreCase("EXTERNOS") && !(validation = new ClientValidation()).validationSendFilesSigned()) {
                this.alerta.displayAlertWarning(this.msgUtil.getValue("MSG_VALIDATION_DES"));
                return;
            }
            String passwordCertStore = null;
            if (this.holder.getProceso().getPassword() != null) {
                passwordCertStore = this.holder.getProceso().getPassword();
            }
            String pass = passwordCertStore;
            if (this.holder.getCertificateSeleceted() == null) {
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ALERT_HEADER_ERROR"), this.msgUtil.getValue("MSG_SELECT_CERTIFICATE_TITLE"));
                return;
            }
            if (this.holder.getCertificateSeleceted().getCertificate().getNotAfter().before(Calendar.getInstance().getTime())) {
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ALERT_HEADER_ERROR"), this.msgUtil.getValue("MSG_CAROOT_EXPIRED"));
                return;
            }
            String nroDocumento = SignUtils.obtenerNroDocumento(this.holder.getCertificateSeleceted().getCertificate().getSubjectDN().toString());
            if (this.holder.getProceso().getDetalleFirmantes() != null && !this.holder.getProceso().getDetalleFirmantes().isEmpty() && this.holder.getProceso().getDetalleFirmantes().get(0).getValidarFirmante() != null && this.holder.getProceso().getDetalleFirmantes().get(0).getValidarFirmante().booleanValue() && !(match = this.holder.getProceso().getDetalleFirmantes().stream().anyMatch(f -> f.getDocumentoNumero().equals(nroDocumento)))) {
                String os = OSValidator.getOperatingSystem();
                LOGGER.log(Level.INFO, "OS: {0}", os);
                if (!os.equalsIgnoreCase("LINUX")) {
                    if (event != null) {
                        StageUtil stageUtil2 = new StageUtil();
                        stageUtil2.close((Event)event);
                    } else {
                        Node nodeClose = (Node)ke.getSource();
                        Stage stage = (Stage)nodeClose.getScene().getWindow();
                        stage.close();
                    }
                }
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ALERT_HEADER_ERROR"), this.msgUtil.getValue("MSG_ERROR_DOCUMENTO_NO_COINCIDE"));
                return;
            }
            if (event != null) {
                stageUtil = new StageUtil();
                stageUtil.close((Event)event);
            } else {
                Node nodeClose = (Node)ke.getSource();
                Stage stage = (Stage)nodeClose.getScene().getWindow();
                stage.close();
            }
            stageUtil = new StageUtil();
            stageUtil.openLoading();
            SignBackgroundWorkerService worker = new SignBackgroundWorkerService(this.holder.getCertificateSeleceted(), pass, this.holder.getSofisFile(), "USER_DATA", this.holder.getParemeterIdentifier(), false, this.holder.getOpciones(), this.holder.getProceso().getMetodoFirma().name(), this.alerta);
            worker.execute();
        }
        catch (Exception e) {
            Logger.getLogger(ClientService.class.getName()).log(Level.SEVERE, null, e);
        }
    }
}

