/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.business.validation;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.exceptions.CARootVerificationException;

public class CARootValidation {
    static MessagesUtil msgUtil = new MessagesUtil(null);
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());

    private CARootValidation() {
    }

    public static PKIXCertPathBuilderResult validateCertificate(X509Certificate cert, Set<X509Certificate> additionalCerts) throws CARootVerificationException {
        try {
            if (CARootValidation.isSelfSigned(cert)) {
                throw new CARootVerificationException(msgUtil.getValue("MSG_CARootValidation_SELF_SIGNED"));
            }
            HashSet<X509Certificate> trustedRootCerts = new HashSet<X509Certificate>();
            HashSet<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();
            for (X509Certificate additionalCert : additionalCerts) {
                if (CARootValidation.isSelfSigned(additionalCert)) {
                    trustedRootCerts.add(additionalCert);
                    continue;
                }
                intermediateCerts.add(additionalCert);
            }
            PKIXCertPathBuilderResult verifiedCertChain = CARootValidation.verifyCertificate(cert, trustedRootCerts, intermediateCerts);
            return verifiedCertChain;
        }
        catch (CertPathBuilderException certPathEx) {
            throw new CARootVerificationException(msgUtil.getValue("MSG_CARootValidation_ERROR_PATH"), certPathEx);
        }
        catch (Exception ex) {
            throw new CARootVerificationException(msgUtil.getValue("MSG_CARootValidation_ERROR_GENERAL"), ex);
        }
    }

    public static boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (SignatureException sigEx) {
            return false;
        }
        catch (InvalidKeyException keyEx) {
            return false;
        }
    }

    private static PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert, Set<X509Certificate> trustedRootCerts, Set<X509Certificate> intermediateCerts) throws GeneralSecurityException {
        try {
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(cert);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (X509Certificate trustedRootCert : trustedRootCerts) {
                trustAnchors.add(new TrustAnchor(trustedRootCert, null));
            }
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            pkixParams.setRevocationEnabled(false);
            CertStore intermediateCertStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(intermediateCerts), "BC");
            pkixParams.addCertStore(intermediateCertStore);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(pkixParams);
            return result;
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(CARootValidation.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception ", e);
        }
        return null;
    }
}

